/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junitxmlformatter;

import io.cucumber.messages.TimeConversion;
import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.Timestamp;
import java.time.Instant;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

class XmlReportData {
    private static final long MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private final Comparator<TestStepResult> testStepResultComparator = Comparator.nullsFirst(Comparator.comparing(o -> o.getStatus().ordinal()));
    private Instant testRunStarted;
    private Instant testRunFinished;
    private final Deque<String> testCaseStartedIds = new ConcurrentLinkedDeque<String>();
    private final Map<String, Instant> testCaseStartedIdToStartedInstant = new ConcurrentHashMap<String, Instant>();
    private final Map<String, Instant> testCaseStartedIdToFinishedInstant = new ConcurrentHashMap<String, Instant>();
    private final Map<String, TestStepResult> testCaseStartedIdToResult = new ConcurrentHashMap<String, TestStepResult>();
    private final Map<String, TestStepResultStatus> testStepIdToTestStepResultStatus = new ConcurrentHashMap<String, TestStepResultStatus>();
    private final Map<String, String> testCaseStartedIdToTestCaseId = new ConcurrentHashMap<String, String>();
    private final Map<String, TestCase> testCaseIdToTestCase = new ConcurrentHashMap<String, TestCase>();
    private final Map<String, Pickle> pickleIdToPickle = new ConcurrentHashMap<String, Pickle>();
    private final Map<String, String> pickleIdToScenarioAstNodeId = new ConcurrentHashMap<String, String>();
    private final Map<String, String> scenarioAstNodeIdToFeatureName = new ConcurrentHashMap<String, String>();
    private final Map<String, String> stepAstNodeIdToStepKeyWord = new ConcurrentHashMap<String, String>();
    private final Map<String, String> pickleAstNodeIdToLongName = new ConcurrentHashMap<String, String>();
    private static final Duration ZERO_DURATION = new Duration(Long.valueOf(0L), Long.valueOf(0L));
    private static final TestStepResult SCENARIO_WITH_NO_STEPS = new TestStepResult(ZERO_DURATION, null, TestStepResultStatus.PASSED, null);

    XmlReportData() {
    }

    void collect(Envelope envelope) {
        envelope.getTestRunStarted().ifPresent(event -> {
            this.testRunStarted = TimeConversion.timestampToJavaInstant((Timestamp)event.getTimestamp());
        });
        envelope.getTestRunFinished().ifPresent(this::testRunFinished);
        envelope.getTestCaseStarted().ifPresent(this::testCaseStarted);
        envelope.getTestCaseFinished().ifPresent(this::testCaseFinished);
        envelope.getTestStepFinished().ifPresent(this::testStepFinished);
        envelope.getGherkinDocument().ifPresent(this::source);
        envelope.getPickle().ifPresent(this::pickle);
        envelope.getTestCase().ifPresent(this::testCase);
    }

    private void testRunFinished(TestRunFinished event) {
        this.testRunFinished = TimeConversion.timestampToJavaInstant((Timestamp)event.getTimestamp());
    }

    private void testCaseStarted(TestCaseStarted event) {
        this.testCaseStartedIds.add(event.getId());
        this.testCaseStartedIdToStartedInstant.put(event.getId(), TimeConversion.timestampToJavaInstant((Timestamp)event.getTimestamp()));
        this.testCaseStartedIdToTestCaseId.put(event.getId(), event.getTestCaseId());
    }

    private void testCaseFinished(TestCaseFinished event) {
        this.testCaseStartedIdToFinishedInstant.put(event.getTestCaseStartedId(), TimeConversion.timestampToJavaInstant((Timestamp)event.getTimestamp()));
    }

    private void testStepFinished(TestStepFinished event) {
        this.testStepIdToTestStepResultStatus.put(event.getTestStepId(), event.getTestStepResult().getStatus());
        this.testCaseStartedIdToResult.compute(event.getTestCaseStartedId(), (__, previousStatus) -> this.mostSevereResult((TestStepResult)previousStatus, event.getTestStepResult()));
    }

    private TestStepResult mostSevereResult(TestStepResult a, TestStepResult b) {
        return this.testStepResultComparator.compare(a, b) >= 0 ? a : b;
    }

    private void source(GherkinDocument event) {
        event.getFeature().ifPresent(feature -> feature.getChildren().forEach(featureChild -> {
            featureChild.getRule().ifPresent(rule -> rule.getChildren().forEach(ruleChild -> {
                ruleChild.getScenario().ifPresent(scenario -> this.scenario((Feature)feature, (Rule)rule, (Scenario)scenario));
                ruleChild.getBackground().ifPresent(background -> background.getSteps().forEach(step -> this.stepAstNodeIdToStepKeyWord.put(step.getId(), step.getKeyword())));
            }));
            featureChild.getBackground().ifPresent(background -> background.getSteps().forEach(step -> this.stepAstNodeIdToStepKeyWord.put(step.getId(), step.getKeyword())));
            featureChild.getScenario().ifPresent(scenario -> this.scenario((Feature)feature, null, (Scenario)scenario));
        }));
    }

    private void scenario(Feature feature, Rule rule, Scenario scenario) {
        this.scenarioAstNodeIdToFeatureName.put(scenario.getId(), feature.getName());
        scenario.getSteps().forEach(step -> this.stepAstNodeIdToStepKeyWord.put(step.getId(), step.getKeyword()));
        String rulePrefix = rule == null ? "" : rule.getName() + " - ";
        this.pickleAstNodeIdToLongName.put(scenario.getId(), rulePrefix + scenario.getName());
        List examples = scenario.getExamples();
        for (int examplesIndex = 0; examplesIndex < examples.size(); ++examplesIndex) {
            Examples currentExamples = (Examples)examples.get(examplesIndex);
            List tableRows = currentExamples.getTableBody();
            for (int exampleIndex = 0; exampleIndex < tableRows.size(); ++exampleIndex) {
                TableRow currentExample = (TableRow)tableRows.get(exampleIndex);
                StringBuilder suffix = new StringBuilder(" - ");
                if (!currentExamples.getName().isEmpty()) {
                    suffix.append(currentExamples.getName()).append(" - ");
                }
                suffix.append("Example #").append(examplesIndex + 1).append(".").append(exampleIndex + 1);
                this.pickleAstNodeIdToLongName.put(currentExample.getId(), rulePrefix + scenario.getName() + suffix);
            }
        }
    }

    private void pickle(Pickle event) {
        this.pickleIdToPickle.put(event.getId(), event);
        event.getAstNodeIds().stream().findFirst().ifPresent(id -> this.pickleIdToScenarioAstNodeId.put(event.getId(), (String)id));
    }

    private void testCase(TestCase testCase) {
        this.testCaseIdToTestCase.put(testCase.getId(), testCase);
    }

    double getSuiteDurationInSeconds() {
        if (this.testRunStarted == null || this.testRunFinished == null) {
            return 0.0;
        }
        return XmlReportData.durationInSeconds(this.testRunStarted, this.testRunFinished);
    }

    double getDurationInSeconds(String testCaseStartedId) {
        return XmlReportData.durationInSeconds(this.testCaseStartedIdToStartedInstant.get(testCaseStartedId), this.testCaseStartedIdToFinishedInstant.get(testCaseStartedId));
    }

    private static double durationInSeconds(Instant testRunStarted, Instant testRunFinished) {
        return (double)java.time.Duration.between(testRunStarted, testRunFinished).toMillis() / (double)MILLIS_PER_SECOND;
    }

    Map<TestStepResultStatus, Long> getTestCaseStatusCounts() {
        return this.testCaseStartedIdToResult.values().stream().map(TestStepResult::getStatus).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    int getTestCaseCount() {
        return this.testCaseStartedIdToStartedInstant.size();
    }

    String getPickleName(String testCaseStartedId) {
        String testCaseId = this.testCaseStartedIdToTestCaseId.get(testCaseStartedId);
        String pickleId = this.testCaseIdToTestCase.get(testCaseId).getPickleId();
        Pickle pickle = this.pickleIdToPickle.get(pickleId);
        List astNodeIds = pickle.getAstNodeIds();
        String pickleAstNodeId = (String)astNodeIds.get(astNodeIds.size() - 1);
        return this.pickleAstNodeIdToLongName.getOrDefault(pickleAstNodeId, pickle.getName());
    }

    public String getFeatureName(String testCaseStartedId) {
        String testCaseId = this.testCaseStartedIdToTestCaseId.get(testCaseStartedId);
        String pickleId = this.testCaseIdToTestCase.get(testCaseId).getPickleId();
        String astNodeId = this.pickleIdToScenarioAstNodeId.get(pickleId);
        return this.scenarioAstNodeIdToFeatureName.get(astNodeId);
    }

    LinkedHashMap<String, String> getStepsAndResult(String testCaseStartedId) {
        String testCaseId = this.testCaseStartedIdToTestCaseId.get(testCaseStartedId);
        TestCase testCase = this.testCaseIdToTestCase.get(testCaseId);
        Pickle pickle = this.pickleIdToPickle.get(testCase.getPickleId());
        return testCase.getTestSteps().stream().filter(testStep -> testStep.getPickleStepId().isPresent()).collect(Collectors.toMap(this.renderTestStepText(pickle), this::renderTestStepResult, (existing, replacement) -> replacement, LinkedHashMap::new));
    }

    private String renderTestStepResult(TestStep testStep) {
        return this.testStepIdToTestStepResultStatus.get(testStep.getId()).value().toLowerCase(Locale.ROOT);
    }

    private Function<TestStep, String> renderTestStepText(Pickle pickle) {
        return testStep -> {
            String pickleId = testStep.getPickleStepId().orElse(null);
            Optional<PickleStep> pickleStep = pickle.getSteps().stream().filter(s -> s.getId().equals(pickleId)).findFirst();
            String stepKeyWord = pickleStep.map(s -> (String)s.getAstNodeIds().get(0)).map(this.stepAstNodeIdToStepKeyWord::get).orElse("");
            String stepText = pickleStep.map(PickleStep::getText).orElse("");
            return stepKeyWord + stepText;
        };
    }

    Deque<String> testCaseStartedIds() {
        return this.testCaseStartedIds;
    }

    TestStepResult getTestCaseStatus(String testCaseStartedId) {
        return this.testCaseStartedIdToResult.getOrDefault(testCaseStartedId, SCENARIO_WITH_NO_STEPS);
    }
}

