/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages;

import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Timestamp;
import java.time.Instant;

public final class Convertor {
    private Convertor() {
    }

    public static Exception toMessage(Throwable t) {
        return new Exception(t.getClass().getName(), t.getMessage());
    }

    public static Timestamp toMessage(Instant instant) {
        return new Timestamp(instant.getEpochSecond(), Long.valueOf(instant.getNano()));
    }

    public static Duration toMessage(java.time.Duration duration) {
        return new Duration(duration.getSeconds(), Long.valueOf(duration.getNano()));
    }

    public static Instant toInstant(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static java.time.Duration toDuration(Duration duration) {
        return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
    }
}

