package step;

//import business.Auswerter;

import business.AuswerterInterface;
import io.cucumber.java.Before;
import io.cucumber.java.ParameterType;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.junit.jupiter.api.Assertions;


public class KniffelSteps {
    private AuswerterInterface auswerter;
    private List<Integer> wuerfel;
    private int punkte;
    
    @ParameterType("\\d+,\\d+,\\d+,\\d+,\\d+")
    public List<Integer> wuerfel(String txt) {
      System.out.println("Mein Converter2 bekommt: " + txt);
      List<Integer> ergebnis = new ArrayList<Integer>();
      String[] werte = txt.split(",");
      try {
        for(int i = 0; i < werte.length; i++) {
          ergebnis.add(Integer
              .parseInt(werte[i]));
        }
      } catch (Exception e) {
        throw new IllegalArgumentException(
            "Wuerfe nicht korrekt angegeben: " + Arrays.asList(werte));
      }
      return ergebnis;
    }

    @Before
    public void setUp() {
        //this.auswerter = new Auswerter();
    }

    @When("ich {wuerfel} geworfen habe")
    public void ich_geworfen_habe(List<Integer> wuerfel) throws Throwable {
        this.wuerfel = wuerfel;
    }

    @When("^nur (\\d+)er auswerten lasse$")
    public void nur_er_auswerten_lasse(int wert) throws Throwable {
        this.punkte = this.auswerter.alsGleiche(wert, this.wuerfel);
    }

    @When("^einen Dreierpasch eintrage$")
    public void einen_Dreierpasch_eintrage() throws Throwable {
        this.punkte = this.auswerter.alsDreierpasch(wuerfel);
    }

    @When("^einen Viererpasch eintrage$")
    public void einen_Viererpasch_eintrage() throws Throwable {
        this.punkte = this.auswerter.alsViererpasch(wuerfel);
    }

    @When("^ein Full House eintrage$")
    public void ein_Full_House_eintrage() throws Throwable {
        this.punkte = this.auswerter.alsFullHouse(wuerfel);
    }

    @When("^eine kleine Straße eintrage$")
    public void eine_kleine_Straße_eintrage() throws Throwable {
        this.punkte = this.auswerter.alsKleineStrasse(wuerfel);
    }

    @When("^eine große Straße eintrage$")
    public void eine_große_Straße_eintrage() throws Throwable {
        this.punkte = this.auswerter.alsGrosseStrasse(wuerfel);
    }

    @When("^einen Kniffel eintrage$")
    public void einen_Kniffel_eintrage() throws Throwable {
        this.punkte = this.auswerter.alsKniffel(wuerfel);
    }

    @When("^eine Chance eintrage$")
    public void eine_Chance_eintrage() throws Throwable {
        this.punkte = this.auswerter.alsChance(wuerfel);
    }

    @Then("^erhalte ich (\\d+) Punk(?:t|te)$")
    public void erhalte_ich_Punkt(int arg1) throws Throwable {
        Assertions.assertEquals(arg1, this.punkte);
    }
}
