package alphabet;

/** Interface zeigt einige Experimente mit den Klassen Wort und Zeichen.
 * Genaugenommen gehoeren diese Mezhoden in dier Klasse Wort.
 */
public interface Experimente {
  /** Das uebergebene Wort wird umgedreht, aus 'abcd' wird 'dcba'.
   * und als Ergebnis zurueckgegeben.
   * @param w umzudrehendes Wort
   * @return umgedrehtes Wort
   */
  public Wort umdrehen(Wort w);
  
  /** Die Anzahl der Vorkommen von z in w wird gezaehlt.
   * @param z gesuchtes Zeichen
   * @param w zu analysierendes Wort
   * @return Anzahl der Vorkommen von z in w
   */
  public int vorkommenVonIn(Zeichen z, Wort w);
  
  /** Alle Vorkommen von z in w werden entfernt.
   * @param z zu entfernendes Zeichen
   * @param w zu bearbeitendes Wort
   * @return Wort bei dem alle Vorkommen von z in w entfernt wurden.
   */
  public Wort entfernenVonIn(Zeichen z, Wort w);
}
