package alphabet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

//import endlicherAutomat.EndlicherAutomat;
//import regulaererAusdruck.RegulaererAusdruck;
//import zustand.Zustand;

public class Nichtterminal extends Zeichen // extends RegulaererAusdruck 
  implements Serializable, Cloneable{
  
  private static final long serialVersionUID = 1L;
  //private String zeichen;
  private static Map<String, Nichtterminal> alleNichtterminale = new HashMap<>();
  private static int count = 1;
  
  /** Interner Konstruktor zur Erzeugung des eigentlichen Zeichen-Objekts
   * 
   * @param zeichen in Zeichen umzusetzender String
   */
  private Nichtterminal(String zeichen) {   
    super(zeichen);
    alleNichtterminale.put(zeichen, this);
  }
  
  /** Menge der Nichtterminale werden zurueckgesetzt und damit
   * geloescht.
   */
  public static void reset() {
    Zeichen.loescheAlle(alleNichtterminale.keySet());
    alleNichtterminale = new HashMap<>();
  }
  
  /** Es wird das zum uebergebenen String zugehoerige Nichtterminal
   * zurueckgegeben (das eventuell erst angelegt werden muss).
   * Sollte beim Anlegen  erkannt werden, dass der String Praefix
   * eines anderen Strings oder ein existierendes Nichtterminals Praefix
   * dieses Strings ist, wird eine IllegalStateException geworfen 
   * @param z Name des zu suchenden Nichtterminals
   * @return das zu z gehoerende Nichtterminal
   * @throws IllegalStateException
   */
  public static Nichtterminal nichtterminal(String z) {
    Nichtterminal erg = alleNichtterminale.get(z);
    if (erg == null) {
      for(Zeichen g: Zeichen.alleZeichen()) {
        if(g.getZeichen().startsWith(z) || z.startsWith(g.getZeichen())) {
          throw new IllegalStateException("angedachtes Nichtterminal " + z 
              + " in Praefixbeziehung mit " + g);
        }
      }
      new Nichtterminal(z); 
      //System.out.println(alleNichtterminale);
      return alleNichtterminale.get(z);
    }
    return erg;
  }
  
  /** Ueberprueft ob es schon ein zum String gehoerendes Nichtterminal gibt.
   * 
   * @param z zu pruefender String
   * @return existiert Nichtterminal z
   */
  public static boolean istNichtterminal(String z) {
    return alleNichtterminale.get(z) != null;
  }
  
  /** Gibt die Liste aller bisher eingerichteter Nichtterminale zurueck.
   * 
   * @return Liste aller Nichtterminale
   */
  public static List<Nichtterminal> alleNichtterminale() {
    List<Nichtterminal> tmp = new ArrayList<>();
    for(Nichtterminal n: alleNichtterminale.values()) {
      tmp.add(n);
    }
    return tmp;
  }
  
  /** Berechnet ein neues, bis jetzt nicht vorhandenes, Nichtterminal.
   * 
   * @return garantiert neues Nichtterminal
   */
  public static Nichtterminal neu() {
    boolean neu = false;
    String name = null;
    while(!neu) {
      name = "" + count;
      while(name.length() < 4) {
        name = "0" + name;
      }
      count++;
      if(alleNichtterminale.get("N" + name) == null) {
        neu = true;
      }
    }
    return new Nichtterminal("N" + name);
        
  }

//////////////////////////////////////
  
//  public String getZeichen() {
//    return zeichen;
//  }
//
//  public void setZeichen(String zeichen) {
//    this.zeichen = zeichen;
//  }

//  @Override
//  public String toString() {
//    if (zeichen.equals("/space")) {
//      return " ";
//    }
//    return "" + this.zeichen;
//  }
// 
//  @Override
//  public int hashCode() {
//    return Objects.hashCode(this.zeichen);
//  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
 // Zeichen soll auch mit Terminalzeichen vergleichbar sein
    if (this.getClass() != obj.getClass()
//      &&  obj.getClass() != Terminal.class 
//        && this.getClass() != Terminal.class  
        )
      return false;
    Nichtterminal other = (Nichtterminal) obj;
    return Objects.equals(super.zeichen, other.zeichen);
  }
  
  @Override
  public Nichtterminal clone() {
    return this;
  }
}
