package alphabet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import endlicherAutomat.EndlicherAutomat;
import zustand.Zustand;

public class Terminal extends Zeichen 
  implements Serializable, Cloneable{
  
  private static final long serialVersionUID = 1L;
  //private String zeichen;
  private static Map<String, Terminal> alleTerminale = new HashMap<>();
  
  /** Interner Konstruktor zur Erzeugung des eigentlichen Zeichen-Objekts
   * 
   * @param zeichen in Zeichen umzusetzender String
   */
  private Terminal(String zeichen) {   
    super(zeichen);
    alleTerminale.put(zeichen, this);
  }
  
  /** Menge der Terminale werden zurueckgesetzt und damit
   * geloescht.
   */
  public static void reset() {
    Zeichen.loescheAlle(alleTerminale.keySet());
    alleTerminale = new HashMap<>();
  }
  
  /** Es wird das zum uebergebenen String zugehoerige Terminal
   * zurueckgegeben (das eventuell erst angelegt werden muss).
   * Sollte beim Anlegen erkannt werden, dass der String Praefix
   * eines anderen Strings oder ein existierendes Zeichen Praefix
   * dieses Strings ist, wird eine IllegalStateException geworfen 
   * @param z Name des zu suchenden Terminals
   * @return das zu z gehoerende Terminal
   * @throws IllegalStateException
   */
  public static Terminal terminal(String z) {
    Terminal erg = alleTerminale.get(z);
    if (erg == null) {
      for(Zeichen g: Zeichen.alleZeichen()) {
        if(g.getZeichen().startsWith(z) || z.startsWith(g.getZeichen())) {
          throw new IllegalStateException("angedachtes Terminal " + z 
              + " in Praefixbeziehung mit " + g);
        }
      }
      new Terminal(z); 
      if(z.equals("/space") && alleTerminale.get(" ") == null) {
        new Terminal(" ");
        //System.out.println("********/space");
      }
      if(z.equals(" ") && alleTerminale.get("/space") == null) {
        new Terminal("/space");
        //System.out.println("******** *");
      }
      return alleTerminale.get(z);
    }
    return erg;
  }
  
  /** Ueberprueft ob es schon ein zum String gehoerendes Terminal gibt.
   * 
   * @param z zu pruefender String
   * @return existiert Nichtterminal z
   */
  public static boolean istTerminal(String z) {
    return alleTerminale.get(z) != null;
  }
  
  /** Gibt die Liste aller bisher eingerichteter Terminale zurueck.
   * 
   * @return Liste aller Terminale
   */
  public static List<Terminal> alleTerminale() { 
    List<Terminal> tmp = new ArrayList<>();
    for(Terminal n: alleTerminale.values()) {
      tmp.add(n);
    }
    return tmp;
  }
  
  /** Berechnet eine Liste aller Worte ueber die bekannten 
   * Terminale bis zur Laenge n einschliesslich
   * @param n maximale Wortlaenge
   * @return Liste aller Worte bis zur Laenge n einschliesslich
   */
  public static List<Wort> alleWorteBisLaenge(int n){
    List<Wort> erg = new ArrayList<Wort>();
    erg.add(new Wort());
    List<Wort> tmp = new ArrayList<Wort>();
    tmp.add(new Wort());
    for(int i = 0; i < n; i++) {
      List<Wort> neu = new ArrayList<Wort>();
      for(Wort w: tmp) {
        for(Terminal t: alleTerminale()) {
          neu.add(w.clone().anfuegen(t));
        }
      }
      erg.addAll(neu);
      tmp = neu;
    }
    return erg;
  }
  
  @Override
  public EndlicherAutomat alsAutomat() {
    EndlicherAutomat erg = new EndlicherAutomat();
    Zustand start = Zustand.neu();
    Zustand ende = Zustand.neu();
    List<Terminal> alf = new ArrayList<>();
    //alf.add(this);
    alf.add(this);
    erg.setAlphabet(alf);
    erg.setStart(start);
    //erg.addZeichen(this);
    erg.addZustand(start, ende);
    erg.addEndzustand(ende);
    erg.addUeberfuehrung(start, this, ende);
    return erg;
  }

//////////////////////////////////////
  
//  public String getZeichen() {
//    return zeichen;
//  }
//
//  public void setZeichen(String zeichen) {
//    this.zeichen = zeichen;
//  }

//  @Override
//  public String toString() {
//    if (zeichen.equals("/space")) {
//      return " ";
//    }
//    return "" + this.zeichen;
//  }
// 
//  @Override
//  public int hashCode() {
//    return Objects.hashCode(this.zeichen);
//  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
 // Zeichen soll auch mit Terminalzeichen vergleichbar sein
    if (this.getClass() != obj.getClass()
//      &&  obj.getClass() != Terminal.class 
//        && this.getClass() != Terminal.class  
        )
      return false;
    Terminal other = (Terminal) obj;
    return Objects.equals(super.zeichen, other.zeichen);
  }
  
  @Override
  public Terminal clone() {
    return this;
  }
}
