package alphabet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class Zeichen extends RegulaererAusdruck 
  implements Serializable, Cloneable{
  
  private static final long serialVersionUID = 1L;
  protected String zeichen;
  private static Map<String, Zeichen> alleZeichen = new HashMap<>();
  
  /** Interner Konstruktor zur Erzeugung des eigentlichen Zeichen-Objekts
   * 
   * @param zeichen in Zeichen umzusetzender String
   */
  protected Zeichen(String zeichen) {   
    this.zeichen = zeichen;
    if(zeichen.equals("/space")) {
      if (alleZeichen.get(" ") == null) {
        alleZeichen.put("/space", new Zeichen(" ")); // wird auch " " angelegt
      } else {
        alleZeichen.put("/space", alleZeichen.get(" "));
      }
    } else {
      alleZeichen.put(zeichen, this);
    }
  }
  
  /** Menge der Zeichen werden zurueckgesetzt und damit
   * geloescht.
   */
  public static void reset() {
    //genutzt = new HashSet<>();
    alleZeichen = new HashMap<>();
  }
  
  /** Methode loescht alle zu den Strings aus der uebergebenen Menge
   * gehoerende Zeichen.
   * @param weg zu loeschende Zeichenmenge
   */
  public static void loescheAlle(Set<String> weg) {
    for(String z: weg) {
      alleZeichen.remove(z);
    }
  }
  
  /** Es wird das zum uebergebenen String zugehoerige Zeichen
   * zurueckgegeben (das eventuell erst angelegt werden muss).
   * Sollte beim Anlegen erkannt werden, dass der String Praefix
   * eines anderen Strings oder ein existierendes Zeichen Praefix
   * dieses Strings ist, wird eine IllegalStateException geworfen 
   * @param z Name des zu suchenden Zeichens
   * @return das zu z gehoerende Zeichen
   * @throws IllegalStateException
   */
  public static Zeichen zeichen(String z) {
    Zeichen erg = alleZeichen.get(z);
    if (erg == null) {
      for(String g: alleZeichen.keySet()) {
        if(g.startsWith(z) || z.startsWith(g)) {
          throw new IllegalStateException("Zeichen " + z 
              + " in Praefixbeziehung mit " + g);
        }
      }
      new Zeichen(z); // Aufteilung, falls z =/space ist Ergebnis Zeichen fuer " "
      return alleZeichen.get(z);
    }
    return erg;
  }
  
  /** Ueberprueft ob es schon ein zum String gehoerendes Zeichen gibt.
   * 
   * @param z zu pruefender String
   * @return existiert Zeichen z
   */
  public static boolean istZeichen(String z) {
    return alleZeichen.get(z) != null;
  }
  
  /** Gibt die Liste aller bisher eingerichteter Zeichen zurueck.
   * 
   * @return Liste aller Terminale
   */
  public static List<Zeichen> alleZeichen() {
    List<Zeichen> tmp = new ArrayList<>();
    for(Zeichen n: alleZeichen.values()) {
      tmp.add(n);
    }
    return tmp;
  }

//////////////////////////////////////
  
  public String getZeichen() {
    return zeichen;
  }

  public void setZeichen(String zeichen) {
    this.zeichen = zeichen;
  }

  @Override
  public String toString() {
    if (zeichen.equals("/space")) {
      return " ";
    }
    return "" + this.zeichen;
  }
  
  @Override
  public EndlicherAutomat alsAutomat() {
    throw new IllegalStateException("Regulaere Ausdruecke bestehen aus"
        + " Terminal-Objekten, keinen Zeichen-Objekten");
  }
 
//  @Override
//  public EndlicherAutomat alsAutomat() {
//    EndlicherAutomat erg = new EndlicherAutomat();
//    Zustand start = Zustand.neu();
//    Zustand ende = Zustand.neu();
//    List<Terminal> alf = new ArrayList<>();
//    //alf.add(this);
//    alf.add((Terminal) this);
//    erg.setAlphabet(alf);
//    erg.setStart(start);
//    //erg.addZeichen(this);
//    erg.addZustand(start, ende);
//    erg.addEndzustand(ende);
//    erg.addUeberfuehrung(start, (Terminal)this, ende);
//    return erg;
//  }

  @Override
  public int hashCode() {
    return Objects.hashCode(this.zeichen);
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
 // Zeichen soll auch mit Terminalzeichen vergleichbar sein
    if (this.getClass() != obj.getClass()
//      &&  obj.getClass() != Terminal.class 
//        && this.getClass() != Terminal.class  
        )
      return false;
    Zeichen other = (Zeichen) obj;
    return Objects.equals(zeichen, other.zeichen);
  }
  
  @Override
  public Zeichen clone() {
    return this;
  }
}
