package ausfuehrung;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

import alphabet.Wort;

public class Ableitung implements Iterable<Regelnutzung>{
  private List<Regelnutzung> sequenz;
  private boolean erfolgreich;
  private Wort abgeleitet;
  
  public Ableitung() {
    this.sequenz = new ArrayList<>();
  }
  /** Erzeugt ein Ableitungsobjekt auf der Basis der uebergebenen sequenz,
   * die zuerst in eine Linksableitung umgeformt wird, das Flag gibt an, 
   * ob die ueberegebene Ableitung erfolgreich war und das Wort ist die
   * Sequenz von Terminalzeichen, die mit der Ableitung erreicht wird.
   * @param sequenz Folge von genutzten Regeln, die in Linksableitung
   *        umgeformt wird
   * @param erfolgreich war Ableitungserstellung erreichbar
   * @param abgeleitet welches Wort wird die Ableitung berechnet
   */
  public Ableitung(List<Regelnutzung> sequenz, boolean erfolgreich,
      Wort abgeleitet) {
    super();
    this.sequenz = sequenz;
    if (erfolgreich) {
      this.sequenz = this.inLinksableitung(sequenz);
    }
    //this.sequenz = sequenz;
    this.erfolgreich = erfolgreich;
    this.abgeleitet = abgeleitet;
  }

  /** Die uebergbene Sequenz von Regelnutzungen wird in eine aequivalente
   * Sequenz in Form einer Linksableitung umgeformt.
   * @param seq zu bearbeitende Sequenz von Regelnutzungen
   * @return aequivalente Sequenz von Regeln als Linksableitung
   */
  public List<Regelnutzung> inLinksableitung(List<Regelnutzung> seq2){
    List<Regelnutzung> seq = new ArrayList<>(); // falls seq2 immutable
    for(Regelnutzung rn:seq2) {
      seq.add(rn);
    }
    if (seq == null || seq.size() == 0) {
      return seq;
    }
    List<Regelnutzung> erg = new ArrayList<>();
    Wort w = new Wort(seq.get(0).getRegel().getLinks()); 
    int check = seq.size() + 1;
    while(!seq.isEmpty()) {
      if (check == seq.size()) {
        throw new IllegalStateException("Regelfolge nicht nutzbar: " + seq);
      }
      check = seq.size();
      
      for (int pos = 0; pos < seq.size(); pos++) {
        int erstes = w.positionErstesNichtterminal();
        Regelnutzung rn = seq.get(pos);
        if (erstes == rn.getPosition() && w.at(erstes).equals(rn.getRegel().getLinks())) {
          //System.out.println("\n\n********pos: " + pos + "\n seq: " + seq + "\n rn: " + rn + "\n********\n");
          Regelnutzung rtmp = seq.remove(pos);
          erg.add(rtmp);
          //erg.add(seq.remove(pos));
          w = rn.anwenden(w);
          
          // Regeln vorher verschieben
          int delta = rn.getRegel().getRechts().laenge() - 1;
          //System.out.println("delta: " + delta);
          if(delta != 0) {
            for (int d = 0; d < pos; d++) {
              seq.get(d).setPosition(seq.get(d).getPosition() + delta);
            }
          }
          break;
        }
      }
    }
    return erg;
  }
  
  /* alt und unvollstaendig */
  public List<Regelnutzung> inLinksableitungX(List<Regelnutzung> seq){
    if (seq == null || seq.size() == 0) {
      return seq;
    }
    List<Regelnutzung> erg = new ArrayList<>();
    List<Regelnutzung> spaeter = new ArrayList<>();
    Wort w = new Wort(seq.get(0).getRegel().getLinks()); 
    for (int pos = 0; pos < seq.size(); pos++) {
      //System.out.println("\nSpaeter:\n " + spaeter);
      Regelnutzung rn = seq.get(pos);
      int erstes; 
      erstes = w.positionErstesNichtterminal();
      if (!spaeter.isEmpty()) {
        w = bearbeiteVerschobeneRegeln(erg, seq, pos, spaeter, w, erstes);
        erstes = w.positionErstesNichtterminal();
      }
      if (erstes == rn.getPosition()) {
        erg.add(rn);
        w = rn.anwenden(w);
        int delta = rn.getRegel().getRechts().laenge() - 1;
        //System.out.println("delta: " + delta);
        if(delta != 0) {
          for (int d = 0; d < spaeter.size(); d++) {
            if(spaeter.get(d).getPosition() >= erstes - (delta == -1? 1: 0)) {
              spaeter.get(d).setPosition(spaeter.get(d).getPosition() + delta);
            }
          }
//          for (int d = pos; d < seq.size(); d++) {
//            if(seq.get(d).getPosition() >= erstes) {
//              seq.get(d).setPosition(seq.get(d).getPosition() + delta);
//            }
//          }
        }
      } else {
        spaeter.add(rn);
      }
    }
//    for (Regelnutzung rn: spaeter) {
//      erg.add(rn);
//    }
    int tmp = 0;
    while(tmp != spaeter.size()) {
      tmp = spaeter.size();
      bearbeiteVerschobeneRegeln(erg, seq, seq.size(), spaeter, w, w.positionErstesNichtterminal());
    }
    for (Regelnutzung rn : spaeter) {
      System.err.println(rn);
    }
    return erg;
  }

  private Wort bearbeiteVerschobeneRegeln(List<Regelnutzung> erg,
      List<Regelnutzung> seq, int pos, List<Regelnutzung> spaeter, Wort w, int erstes) {
    for(int i = 0; i < spaeter.size(); i++) {
      Regelnutzung tmp = spaeter.get(i);
      if (erstes == tmp.getPosition()) {
        erg.add(tmp);
        w = tmp.anwenden(w);
        int delta = tmp.getRegel().getRechts().laenge() - 1;
        //System.out.println("delta2: " + delta);
        if(delta != 0) {
          for (int d = i + 1; d < spaeter.size(); d++) {
            if(spaeter.get(d).getPosition() >= erstes - (delta == -1? 1: 0)) {
              spaeter.get(d).setPosition(spaeter.get(d).getPosition() + delta);
            }
          }
//              for (int d = pos; d < seq.size(); d++) {
//                if(seq.get(d).getPosition() >= erstes) {
//                  seq.get(d).setPosition(seq.get(d).getPosition() + delta);
//                }
//              }
        }
        spaeter.remove(i);
        i--;
        erstes = w.positionErstesNichtterminal();
        // Positionsverschiebung?
      } else {
        spaeter.remove(i);
        spaeter.add(tmp);
      }
    }
    return w;
  }
  
  public void forEach(Consumer<? super Regelnutzung> action) {
    sequenz.forEach(action);
  }

  /** ermoeglich die Iteration ueber die Sequenz angewandter Regeln.
   * 
   */
  public Iterator<Regelnutzung> iterator() {
    return sequenz.iterator();
  }

  /** Anzahl der Regeln in der Liste der Regeln.
   * @return Anzahl der Regeln.
   */
  public int size() {
    return sequenz.size();
  }

  /** Eine uebergebene Regelnutzung wird an die bisherigen Regelnutzungen
   * angehaengt
   * @param e anzuhaengende Regelnutzung
   * @return war Anfuegen erfolgreich?
   */
  public boolean add(Regelnutzung e) {
    return sequenz.add(e);
  }

  /** gibt die i-te Regelnutzung der Sequenz zurueck
   * 
   * @param index Nummer der gesuchten Regelnutzung
   * @return Regelnutzung an i-ter Position
   */
  public Regelnutzung get(int index) {
    return sequenz.get(index);
  }

  public List<Regelnutzung> getSequenz() {
    return sequenz;
  }

  public void setSequenz(List<Regelnutzung> sequenz) {
    this.sequenz = sequenz;
  }

  public boolean isErfolgreich() {
    return erfolgreich;
  }

  public void setErfolgreich(boolean erfolgreich) {
    this.erfolgreich = erfolgreich;
  }

  public Wort getAbgeleitet() {
    return abgeleitet;
  }

  public void setAbgeleitet(Wort abgeleitet) {
    this.abgeleitet = abgeleitet;
  }

  @Override
  public int hashCode() {
    return Objects.hash(abgeleitet, erfolgreich, sequenz);
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    Ableitung other = (Ableitung) obj;
    return Objects.equals(abgeleitet, other.abgeleitet)
        && erfolgreich == other.erfolgreich
        && Objects.equals(sequenz, other.sequenz);
  }

  @Override
  public String toString() {
    return "Ableitung [sequenz=" + sequenz + ", erfolgreich="
        + erfolgreich + ", abgeleitet=" + abgeleitet + "]";
  }
}
