package ausfuehrung;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import alphabet.Nichtterminal;

public class CYKKnoten implements Cloneable{
  private Nichtterminal n;
  private ArrayList<Regelnutzung> regeln; // nicht List um clone() zu nutzen
  
  /** Erzeugt Hilfsobjekt, mit dem festgehalten wird, 
   *  (1) welche Ableitung aus dem Nichtterminal im Rahmen der Nutzung
   *      der Chomsky-Normalform abgeleitet wurden 
   *  (2) welche Ableitung aus dem Nichtterminal zum leeren Wort fuehrt
   * @param n betrachtetes Nichtterminal
   * @param regel erste Regel die genutzt wird
   */
  public CYKKnoten(Nichtterminal n, Regelnutzung regel) {
    super();
    this.n = n;
    this.regeln = new ArrayList<>();
    this.regeln.add(regel);
  }
  
  public CYKKnoten(Nichtterminal n) {
    super();
    this.n = n;
    this.regeln = new ArrayList<>();
  }
  
  /** Eine uebergebene Regelnutzung wird an die bisherigen Regelnutzungen
   * angehaengt
   * @param regel anzuhaengende Regelnutzung
   * @return dieses um Regelnutzung erweitertes Objekt
   */
  public CYKKnoten hinzu (Regelnutzung regel) {
    this.regeln.add(regel);
    return this;
  }
  
  /** Uebergebene Regelnutzungen werden an die bisherigen Regelnutzungen
   * angehaengt
   * @param regel anzuhaengende Regelnutzungen
   * @return dieses um Regelnutzungen erweitertes Objekt
   */
  public CYKKnoten hinzu (List<Regelnutzung> regeln) {
    this.regeln.addAll(regeln);
    return this;
  }

  public Nichtterminal getN() {
    return n;
  }

  public void setN(Nichtterminal n) {
    this.n = n;
  }

  public List<Regelnutzung> getRegeln() {
    return regeln;
  }

  public void setRegeln(ArrayList<Regelnutzung> regeln) {
    this.regeln = regeln;
  }

  /*
  public boolean contains(Object o) {
    return regeln.contains(o);
  }
  */

  @Override
  public int hashCode() {
    return Objects.hash(n, regeln);
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    CYKKnoten other = (CYKKnoten) obj;
    return Objects.equals(n, other.n)
        && Objects.equals(regeln, other.regeln);
  }

  @Override
  public String toString() {
    return "CYKKnoten [n=" + n + ", regeln=" + regeln + "]";
  }
  
  @SuppressWarnings("unchecked")
  @Override
  public CYKKnoten clone() {
    CYKKnoten erg = new CYKKnoten(n);
    erg.regeln = (ArrayList<Regelnutzung>)this.regeln.clone(); // flache Kopie reicht
    return erg;
  }
  

}
