package ausfuehrung;

import java.util.Objects;

import alphabet.Wort;
import grammatik.KontextfreieRegel;

public class Regelnutzung {
  private KontextfreieRegel regel;
  private int position;
  
  /** Gibt an an welcher Position eine Regel auf ein Wort angewandt wird.
   * 
   * @param regel angewandte Regel
   * @param position Position des zu ersetzenden Nichtterminals
   */
  public Regelnutzung(KontextfreieRegel regel, int position) {
    this.regel = regel;
    this.position = position;
  }
  
  public KontextfreieRegel getRegel() {
    return regel;
  }
  
  /** Die zugehoerige Regel wird an der zugehoerigen Position auf das
   * uebergebene Wort w angewandt, das daraus resultierende Wort ist 
   * das Ergebnis. Sollte die Position nicht vorhanden sein, wird eine
   * IllegalStateException geworfen.
   * @param w Wort auf das die Regel an der Position angewandt werden soll
   * @return resultierendes Wort nach Anwendung der Regel
   */
  public Wort anwenden(Wort w) {
    if (!w.at(this.position).equals(this.regel.getLinks())){
      throw new IllegalStateException(this.regel + " kann nicht an Position "
          + this.position + " angewandt werden, gefunden:" + w.at(this.position));
    }
    w.ersetzeAnPositionMit(this.position, this.regel.getRechts());
    return w;
  }
  
  public void setRegel(KontextfreieRegel regel) {
    this.regel = regel;
  }
  
  public int getPosition() {
    return position;
  }
  
  public void setPosition(int position) {
    this.position = position;
  }
  
  @Override
  public int hashCode() {
    return Objects.hash(position, regel);
  }
  
  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    Regelnutzung other = (Regelnutzung) obj;
    return position == other.position
        && Objects.equals(regel, other.regel);
  }

  @Override
  public String toString() {
    return "Regelnutzung [regel=" + regel + ", position=" + position
        + "]";
  }
}
