package baum;

import java.awt.Font;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.JComponent;

import baumInterface.Baum;

public class Baumdarstellung {
  private int zeilenabstand = 40;
  private int zwischen = 5;
  private Interaktionsbrett ib;
  private List<List<Baum>> ebenen; // Liste der Baeume pro Darstellungsebene
  private List<Integer> breiten; // Bereiten der Baumdarstellung pro Ebene
  private int maxeinzeln = 0; // breitester Einzelkonten
  private int maxzeile = 0;  // laengste darzustellende Ebene (Zeile)
  private int hoehe = 0;
  private Map<Baum, Integer> positionen; // pro Baum berechnete x-Position
  
  private Font font = new Font(Font.SANS_SERIF, Font.PLAIN, 12);
  
  private Baum baum;

  public static Baumdarstellung darstellen(Baum baum) {
    Baumdarstellung tmp = new Baumdarstellung(baum, true);
    tmp.mitInteraktionsbrettDarstellen();
    return tmp;
  }
  
  public static Baumdarstellung nachUMLet(Baum baum) {
    Baumdarstellung tmp = new Baumdarstellung(baum, false);
    tmp.umletExportieren();
    return tmp;
  }
  
  public static Baumdarstellung nachJPG(Baum baum) {
    Baumdarstellung tmp = new Baumdarstellung(baum, false);
    Baumdarstellung.nachJPG(baum);
    return tmp;
  }
  
  private Baumdarstellung(Baum baum, boolean mitInteraktionsbrett) {
     if(mitInteraktionsbrett) {
       this.ib = new Interaktionsbrett();
     }
     this.zwischen = 15;
     this.baum = baum;
     this.ebenen = new ArrayList<>();
     this.ebenen.add(List.of(this.baum)); // oberste Ebene ist Ausgangsbaum
     this.maxeinzeln = this.textlaenge(this.baum.text()); 
     this.breiten = new ArrayList<>();
     this.breiten.add(this.maxeinzeln);
     this.maxzeile = this.maxeinzeln;
     this.positionen = new HashMap<>();
     this.baumEinlesen(this.ebenen.get(0));
     this.baumPlatzieren();
  }
  
  private void mitInteraktionsbrettDarstellen() {
    this.baumZeichnen();
    this.ib.neueGroesse(2*(this.maxzeile + 2*this.maxeinzeln)
        , (this.ebenen.size() + 6) * (this.zeilenabstand));
  }
      
  /** Berechnet der Laenge des Textes in Pixeln.
   * 
   * @param s  darzustellender Text
   * @return Laenge des Texts in Pixeln
   */
  @SuppressWarnings("serial")
  public int textlaenge(String s) {
    if (this.ib == null) {
      return new JComponent() {}.getFontMetrics(this.font).stringWidth(s);
    }
    return this.ib.textlaenge(s);
  }
  
  /** Berechnet die Laenge des Textes in Pixeln, wenn alle Elemente
   * des Arrays aneinander gehaengt werden.
   * @param s darzustellender Array mit Strings
   * @return Laenge in Pixeln des gesamten Arrays
   */
  public int textlaenge(String[] s) {
    return this.textlaenge(this.arrayAlsString(s));
  }
  
  private String arrayAlsString(String[] s) {
    StringBuilder str = new StringBuilder();
    for(String tmp:s) {
      str.append(tmp);
    }
    return str.toString();
  }
  
  private void baumZeichnen(){
    //this.ib.neuerText(10, 20, "TMP");
    //List<Baum> alt = this.ebenen.get(0);
    int y = 20;
    for(int i= 0; i < this.ebenen.size(); i++) {
      for(Baum b: this.ebenen.get(i)) {
        //System.out.println(this.positionen.get(b) + " : " + y);
        this.ib.neuerText(this.positionen.get(b), y, this.arrayAlsString(b.text()));    
        if (!b.istBlatt()) { 
          String aktuell =""; // bisher verarbeiteter Text
          //String vorher="";      // verarbeiteter Text ein Schritt vorher
          int inpos = 0;      // abgearbeitete Position von Nachfolgerknoten
          Integer[] poss = b.docking();
          for(int s = 0; s < b.text().length; s++) {
            //vorher = aktuell;
            aktuell += b.text()[s];
            if(inpos < poss.length && poss[inpos] == s) {  
              //int mitte = this.positionen.get(b) + this.textlaenge(vorher) + (this.textlaenge(aktuell) - this.textlaenge(vorher))/2;
              int mitte = this.positionen.get(b) + this.textlaenge(aktuell) - this.textlaenge(b.text()[s])/2;
              for(int j = 0; j < b.anzahlKnoten(); j++) {
                int mitte2 = this.positionen.get(b.getTeilbaum(inpos)) + this.textlaenge(b.getTeilbaum(inpos).text())/2 + 1;
                //System.out.println("linie: " + mitte + " : " + mitte2);
                this.ib.neueLinie(mitte, y + 2, mitte2, y + this.zeilenabstand - 12);
                inpos++;
              }
              //inpos++;
            }
          }
        }
      }
      y += this.zeilenabstand;
    }
  }
  
  private String zeichenErsetzen(String s) {
    if (s == null) {
      return "";
    }
    StringBuilder erg = new StringBuilder();
    for(int i = 0; i < s.length(); i++) {
      switch(s.charAt(i)) {
        case '<': {
          erg.append("&lt;");
          break;    
        }
        case '>': {
          erg.append("&gt;");
          break;    
        }
        case '/': {
          erg.append("&sol;");
          break;    
        }
        case '\"': {
          erg.append("&quot;");
          break;    
        }
        case '\'': {
          erg.append("&prime;");
          break;    
        }
        case '&': {
          erg.append("&amp;");
          break;    
        }
        default: erg.append(s.charAt(i));
      }
    }
    return erg.toString();
  }
  
  private void umletExportieren() {
    //this.umletVorbereiten();
    Date datum = new Date();
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    String filename = "Baumdiagramm" + simpleDateFormat.format(datum) + ".uxf";
    FileWriter fileWriter;
    PrintWriter pw = null;
    try {
      File file = new File(filename);
      fileWriter = new FileWriter(file);
      System.out.println("umletfile: " + file.getAbsolutePath());
      pw = new PrintWriter(fileWriter);
      pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
      pw.println("<diagram program=\"umlet\" version=\"15.0.0\">");
      pw.println("  <help_text>");
      pw.println("fontsize=" + 12);
      pw.println("  </help_text>\n");
      pw.println("  <zoom_level>10</zoom_level>");

      int y = 20;
      for(int i= 0; i < this.ebenen.size(); i++) {
        for(Baum b: this.ebenen.get(i)) {
          //System.out.println(this.positionen.get(b) + " : " + y);
          String text = this.zeichenErsetzen(this.arrayAlsString(b.text()));
          //this.ib.neuerText(this.positionen.get(b), y, this.arrayAlsString(b.text()));    
//          pw.println("  <element>");
//          pw.println("    <id>Text</id>");
//          pw.println("    <coordinates>");
//          pw.println("      <x>" + (this.positionen.get(b) -4) + "</x>");
//          pw.println("      <y>" + (y - 10) + "</y>");
//          pw.println("      <w>" + (16 + this.ib.textlaenge(text)) + "</w>");
//          pw.println("      <h>30</h>");
//          pw.println("    </coordinates>");
//          pw.println("    <additional_attributes/>");
//          pw.println("    <panel_attributes>" + text+ "\n" 
//                  + /*"halign=center*/"</panel_attributes>");
//          pw.println("  <additional_attributes/>");
//          pw.println("  </element>");
          
          
          if (!b.istBlatt()) { 
            String aktuell =""; // bisher verarbeiteter Text
            //String vorher="";      // verarbeiteter Text ein Schritt vorher
            int inpos = 0;      // abgearbeitete Position von Nachfolgerknoten
            Integer[] poss = b.docking();
            for(int s = 0; s < b.text().length; s++) {
              //vorher = aktuell;
              aktuell += b.text()[s];
              if(inpos < poss.length && poss[inpos] == s) {  
                //int mitte = this.positionen.get(b) + this.textlaenge(vorher) + (this.textlaenge(aktuell) - this.textlaenge(vorher))/2;
                int mitte = this.positionen.get(b) + this.textlaenge(aktuell) - this.textlaenge(b.text()[s])/2;
                for(int j = 0; j < b.anzahlKnoten(); j++) {
                  int mitte2 = this.positionen.get(b.getTeilbaum(inpos)) + this.textlaenge(b.getTeilbaum(inpos).text())/2 + 1;
                  //System.out.println("linie: " + mitte + " : " + mitte2);
                  //this.ib.neueLinie(mitte, y + 2, mitte2, y + this.zeilenabstand - 12);
                  pw.println("  <element>");
                  pw.println("    <id>Relation</id>");
                  pw.println("    <coordinates>");
                  pw.println("      <x>" + (mitte) + "</x>");
                  pw.println("      <y>" + (y) + "</y>");
                  pw.println("      <w>" + (mitte2>mitte ? mitte2 - mitte + 10 : mitte-mitte2 +10) + "</w>");
                  pw.println("      <h>90</h>");
                  pw.println("    </coordinates>");
                  pw.println("    <panel_attributes/>");
                  pw.println("    <additional_attributes>" + "0.0;0.0;" + (mitte2-mitte) + ";" + (this.zeilenabstand-14));
                  pw.println("  </additional_attributes>");
                  pw.println("  </element>");
                  inpos++;
                }
                //inpos++;
              }
            }
          }
          pw.println("  <element>");
          pw.println("    <id>Text</id>");
          pw.println("    <coordinates>");
          pw.println("      <x>" + (this.positionen.get(b) -4) + "</x>");
          pw.println("      <y>" + (y - 14) + "</y>");
          pw.println("      <w>" + (16 + this.textlaenge(text)) + "</w>");
          pw.println("      <h>26</h>");
          pw.println("    </coordinates>");
          pw.println("    <additional_attributes/>");
          pw.println("    <panel_attributes>" + text+ "\n" 
                  + /*"halign=center" + */"valign=center</panel_attributes>");
          pw.println("  <additional_attributes/>");
          pw.println("  </element>");
        }
        y += this.zeilenabstand;
      }
      pw.println("");
      pw.println("");
      pw.println("</diagram>");
      pw.close();
    } catch (IOException e) {
      e.printStackTrace();
    } finally {
      pw.close();
    }

  }
  
  private void baumPlatzieren() {
    //List<Baum> alt = this.ebenen.get(0);
    //this.positionen.put(this.baum, (this.maxzeile + this.textlaenge(this.baum.text()))/2);
    for(int i= 0; i < this.ebenen.size(); i++) {
      List<Baum> tmp = this.ebenen.get(i);
      int verteilen = this.maxzeile - this.breiten.get(i);
      int delta = verteilen / (tmp.isEmpty()? 1: tmp.size());
      //int pos = this.zwischen +(this.maxzeile - this.breiten.get(i))/2;
      int pos = this.zwischen + verteilen - (delta * tmp.size()) + delta/2;
      for(Baum b: tmp) {
        if(this.positionen.get(b) != null) {
          // System.out.println("  b existiert: " + b);
        }
        this.positionen.put(b, pos);
        pos = pos + this.textlaenge(b.text()) + this.zwischen + delta;
        //System.out.print("  " +pos);
      }
      //System.out.println();
    }
//    int pos = this.zeilenabstand;
//    for(Baum b: this.ebenen.get(this.laengsteZeile)) {
//      this.positionen.put(b, pos);
//      pos = pos + this.ib.textlaenge(b.text()) + this.zeilenabstand;
//    }
  }
  
  /** Liest den Baum ebenenweise ein und packt gefundene Ebenen nach
   * this.ebenen, berechnet weiterhin die zur Darstellung der Ebenene
   * benoetigte Anzahl an Pix fuer this.breite, sucht weiterhin nach
   * dem laengsten einzelnen Text fuer this.maxeinzeln 
   * @param liste Liste von Baeumen der vorherigen Ebene, fuer die die
   *              nachfolgende Ebener berechnet werden soll
   */
  private void baumEinlesen(List<Baum> liste) {
    if (liste.isEmpty()) {
      return;
    }
    List<Baum> naechste = new ArrayList<>();
    int gesamt = -zwischen;  // ein Zwischenraum weniger als Knoten
    for(Baum b: liste) {
      for(int i = 0; i < b.anzahlKnoten(); i++) {
        Baum tmp = b.getTeilbaum(i);
        naechste.add(tmp);
        int laenge = this.textlaenge(tmp.text());
        gesamt = gesamt + laenge + zwischen;
        if (laenge > this.maxeinzeln) {
          this.maxeinzeln = laenge;
        }
      }
    }
    if (gesamt > this.maxzeile) {
      this.maxzeile = gesamt;
    }
    this.breiten.add(gesamt);
    this.hoehe++;
    this.ebenen.add(naechste);
    this.baumEinlesen(naechste);
  }
  
  
////////////////////get set  

  public Interaktionsbrett getIb() {
    return ib;
  }

  public void setIb(Interaktionsbrett ib) {
    this.ib = ib;
  }

  public List<List<Baum>> getEbenen() {
    return ebenen;
  }

  public void setEbenen(List<List<Baum>> ebenen) {
    this.ebenen = ebenen;
  }

  public int getMaxeinzeln() {
    return maxeinzeln;
  }

  public void setMaxeinzeln(int maxeinzeln) {
    this.maxeinzeln = maxeinzeln;
  }

  public int getMaxzeile() {
    return maxzeile;
  }

  public void setMaxzeile(int maxzeile) {
    this.maxzeile = maxzeile;
  }

  public int getHoehe() {
    return hoehe;
  }

  public void setHoehe(int hoehe) {
    this.hoehe = hoehe;
  }

  public Baum getBaum() {
    return baum;
  }

  public void setBaum(Baum baum) {
    this.baum = baum;
  }

  public int getZeilenabstand() {
    return zeilenabstand;
  }

  public int getZwischen() {
    return zwischen;
  }  
}
