package endlicherAutomat;

import java.io.Serializable;
import java.util.Objects;

import alphabet.Wort;
import zustand.Zustand;

public class AutomatKonfiguration implements Serializable{
  private static final long serialVersionUID = 1L;
  private Zustand zustand;
  private Wort rest;
  
  public AutomatKonfiguration(Zustand zustand, Wort links) {
    super();
    this.zustand = zustand;
    this.rest = links;
  }
  
  @Override
  public String toString() {
    return "(" + this.zustand + ", " + this.rest + ")";
  }

  public Zustand getZustand() {
    return zustand;
  }

  public void setZustand(Zustand zustand) {
    this.zustand = zustand;
  }

  public Wort getRest() {
    return rest;
  }

  public void setRest(Wort links) {
    this.rest = links;
  }
  
  @Override
  public int hashCode() {
    return Objects.hash(rest, zustand);
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    AutomatKonfiguration other = (AutomatKonfiguration) obj;
    return Objects.equals(rest, other.rest)
        && Objects.equals(zustand, other.zustand);
  }

  @Override
  public AutomatKonfiguration clone() {
    return new AutomatKonfiguration(this.zustand.clone(), this.rest.clone());
  }
  
}
