package endlicherAutomat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import alphabet.Terminal;
import util.Paar;
import zustand.Zustand;

public class OptimierterEndlicherAutomat extends EndlicherAutomat{

  private static final long serialVersionUID = 1L;
  
  /** Die Epsilon-Uebergaenge dieses Automaten werden sprachaequivalent
   * entfernt
   * @return dieser Automat ohne Epsilon-Uebergaenge
   */
  @Override
  public EndlicherAutomat epsilonEntfernen() {
    //System.out.println("epsilonEntfernen");
    List<Zustand> weitereEndzustaende = new ArrayList<>();
    for(Zustand zu: this.zustaende) {
      //boolean gefunden = false;
      for(Zustand ende: this.endzustaende) {
        if (this.ueber.mitEpsilonErreichbar(zu).contains(ende)
            && !weitereEndzustaende.contains(zu)) {
          weitereEndzustaende.add(zu);
          //gefunden = true;
        }
      }
    }

    this.ueber.epsilonEntfernen();
    
    for(Zustand zu: weitereEndzustaende) {
      //zu.setEnde(true);
      //System.out.println(zu + " 2:\n" + this + "\n");
      if (!this.endzustaende.contains(zu)) {
        this.endzustaende.add(zu);
      }
    }
    return this;
  }
  
  /** berechnet zu diesem Automaten sprachaequivalenten Automaten
   * mit minimaler Anzahl an Zustaenden, der Automat muss dazu 
   * deterministisch sein
   * @return aequivalenter minimaler Automat
   */
  @Override
  public EndlicherAutomat minimieren() {
    if(! this.istDeterministisch()) {
      throw new IllegalStateException("die Minimierung klappt nur fuer"
          + " deterministische Automaten");
    }
    this.vervollstaendigen();
    this.minimierungzustaende = new ArrayList<>();
    for(Zustand zu: this.zustaende) {
      this.minimierungzustaende.add(zu);
    }
    EndlicherAutomat erg = new EndlicherAutomat();
    erg.alphabet = this.alphabet;

    int zustaende = this.zustaende.size();
    Map<Zustand, Integer> zustandAlsNummer = new HashMap<>();
    for(int i = 0; i < zustaende; i++) {
      zustandAlsNummer.put(this.zustaende.get(i), i);
    }
    this.aequivalent = new boolean[zustaende][zustaende];
    for(int i = 0; i < zustaende - 1; i++) {
      for (int j = i + 1; j < zustaende; j++) {
        this.aequivalent[i][j] = true;
      }
    }
    //this.zeigBooleanArray(zustaende, aequivalent);
    
    for(int i = 0; i < zustaende - 1; i++) {
      for (int j = i + 1; j < zustaende; j++) {
        if (this.endzustaende.contains(this.zustaende.get(i))
                && !this.endzustaende.contains(this.zustaende.get(j))
            || this.endzustaende.contains(this.zustaende.get(j)) 
                && !this.endzustaende.contains(this.zustaende.get(i))) {
          this.aequivalent[i][j] = false;
        }
      }
      //this.zeigBooleanArray(zustaende, aequivalent);
    }
    
    //this.zeigBooleanArray(zustaende, aequivalent);
    
    boolean neuesGefunden = true;
    //int zaehler = 0;
    while(neuesGefunden) {
    //while(zaehler < zustaende) {
      neuesGefunden = false;
      for(int i = 0; i < zustaende - 1; i++) {
        for (int j = i + 1; j < zustaende; j++) {
          if (this.aequivalent[i][j]) {
            for(Terminal z: this.alphabet) {
              Zustand zi = this.ueber.moeglicheFolgezustaende(this.zustaende.get(i), z).get(0);
              Zustand zj = this.ueber.moeglicheFolgezustaende(this.zustaende.get(j), z).get(0);
//              if (this.endzustaende.contains(zi) && !this.endzustaende.contains(zj)
//                  || this.endzustaende.contains(zj) && !this.endzustaende.contains(zi)) {
              // beide Seiten pruefen, da eine Haelfte der Matrix immer false
              // für gleiche Zustaende ist der Eintrag immer false, deshalb vermeiden
              if (!this.aequivalent[zustandAlsNummer.get(zi)][zustandAlsNummer.get(zj)]
                     && !this.aequivalent[zustandAlsNummer.get(zj)][zustandAlsNummer.get(zi)]
                     && !zi.equals(zj) ) {
                this.aequivalent[i][j] = false;
                neuesGefunden = true;
              }
            }
          }
        }
        //this.zeigBooleanArray(zustaende, aequivalent);
      }
      //zaehler ++;
    }
    //this.zeigBooleanArray(zustaende, aequivalent);
    
    List<Zustand> abgearbeitet = new ArrayList<>();
    List<HashSet<Zustand>> neueZustaende = new ArrayList<>();
    Map<Zustand, HashSet<Zustand>> zugeordneteKlasse = new HashMap<>();
    //this.zustaende.forEach(z -> abgearbeitet.add(z));
    for(int i = 0; i < zustaende; i++) {
      Zustand zst = this.zustaende.get(i);
      if (!abgearbeitet.contains(zst)) {
        HashSet<Zustand> neu = new HashSet<>();
        neu.add(zst);
        zugeordneteKlasse.put(zst, neu);
        for (int j = i + 1; j < zustaende; j++) {
          if(aequivalent[i][j]) {
            neu.add(this.zustaende.get(j));
            abgearbeitet.add(this.zustaende.get(j));
            zugeordneteKlasse.put(this.zustaende.get(j), neu);
          }
        }
        neueZustaende.add(neu);
      }
    }
    
    Map<HashSet<Zustand>, Zustand> namen = this.zustandsmengenInZustaende(
        erg, neueZustaende);
    
    erg.ueber = new AutomatUeberfuehrungsfunktion();
    erg.start = namen.get(zugeordneteKlasse.get(this.start));
    //System.out.println("zugeordnet: " + zugeordneteKlasse + " " + zustaende + " " + namen + " " + neueZustaende);
    
    List<Zustand> bearbeitet = new ArrayList<>();
    for(Zustand zu: this.zustaende) {
      if(! bearbeitet.contains(zu)) {
        HashSet<Zustand> klasse = zugeordneteKlasse.get(zu);
        for(Terminal ze: this.alphabet) {
          erg.ueber.add(namen.get(klasse)
              , ze
              , namen.get(zugeordneteKlasse.get(this.ueber.moeglicheFolgezustaende(zu, ze).get(0))));
        }
        bearbeitet.addAll(klasse);
      }
    }
    
    this.alphabet = erg.alphabet;
    this.endzustaende = erg.endzustaende;
    this.start = erg.start;
    this.ueber = erg.ueber;
    this.zustaende = erg.zustaende;
    return this;
  }
  
  /** wandelt diesen Automaten in sprachaequivalenten deterministischen
   * Automaten um
   * @return dieser Automat in deterministischer Form
   */
  public EndlicherAutomat deterministisch() {
    EndlicherAutomat erg = new EndlicherAutomat();
    if(!this.istOhneEpsilon()) {
      this.epsilonEntfernen();
      //System.out.println("eps entfernen");
    }
    this.vervollstaendigen();
    if(this.istDeterministisch()) {
      return this;
    }
    // HashSet statt Set, da Paar kein Set mag (nicht Cloneable)
    List<HashSet<Zustand>> abzuarbeiten = new ArrayList<>();
    List<HashSet<Zustand>> abgearbeitet = new ArrayList<>();
    HashSet<Zustand> start = new HashSet<>();
    start.add(this.start);
    abzuarbeiten.add(start);
    
    Map<Paar<HashSet<Zustand>, Terminal>, HashSet<Zustand>> ueber = new HashMap<>();
    while (!abzuarbeiten.isEmpty()) {
      HashSet<Zustand> aktuell = abzuarbeiten.remove(0);
      for(Terminal ze: this.alphabet) {
        HashSet<Zustand> next = new HashSet<>();
        for(Zustand zu: aktuell) {
          List<Zustand> nzst = new ArrayList<>(); 
          try {
            nzst = this.ueber.moeglicheFolgezustaende(zu, ze);
          } catch(Exception e) {}
          next.addAll(nzst);
        }
        ueber.put(new Paar<>(aktuell, ze), next);
        if(!abgearbeitet.contains(next) && !abzuarbeiten.contains(next)
            && !aktuell.equals(next)) {
          abzuarbeiten.add(next);
        }
      }
      abgearbeitet.add(aktuell);
    }
    
    erg.zustaende = new ArrayList<>();
    erg.endzustaende = new ArrayList<>();
    
    //wandle Zustands-Sets in Strings um
    Map<HashSet<Zustand>, Zustand> namen = this.zustandsmengenInZustaende(
        erg, abgearbeitet);
    
    erg.alphabet = this.alphabet;
    erg.start = namen.get(start);
    erg.ueber = new AutomatUeberfuehrungsfunktion();
    
    //Ueberfuehrungsfunktion uebertragen
    //Map<Paar<HashSet<Zustand>, Terminal>, HashSet<Zustand>> ueber
    ueber.forEach((paar, zustaende) -> {
      erg.ueber.add(namen.get(paar.getLinks()), paar.getRechts(), namen.get(zustaende));
    });
    
    this.alphabet = erg.alphabet;
    this.endzustaende = erg.endzustaende;
    this.start = erg.start;
    this.ueber = erg.ueber;
    this.zustaende = erg.zustaende;
    
    return this;
  }
}
