package grammatik;

import java.util.Objects;

import alphabet.Nichtterminal;
import alphabet.Wort;

public class KontextfreieRegel implements Cloneable{

	private Nichtterminal links; // linke Seite
	private Wort rechts;         // rechte Seite
	private String id;           // optionaler Identifikator
	
	public KontextfreieRegel(Nichtterminal links, Wort rechts) {
		this.links = links;
		this.rechts = rechts;
	}
	
	public KontextfreieRegel(Nichtterminal links, Wort rechts, String id) {
    this.links = links;
    this.rechts = rechts;
    this.id = id;
  }
	
	/** Die Regel wird auf das nr-te Vorkommen der linken Seite der Regel
	 * in dem uebergebenen Wort w angewandt.
	 * @param w Wort, auf das die Regel angewandt wird
	 * @param nr nr-tes Vorkommen der letzten Seite soll ersetzt werden
	 * @return uebergebenes Wort nach Regelanwendung
	 */
	public Wort anwendenAufAn(Wort w, int nr) {
		return w.ersetzenVonMitNummer(this.links, this.rechts, nr);
	}
	
	/** Die Regel wird auf das pos-te Zeichen des uebergebenen Wortes
	 * angewandt 
   * @param pos Position des Zeichens, das ersetzt werden soll
   * @param w Wort, auf das die Regel angewandt wird
   * @return uebergebenes Wort nach Regelanwendung
   */
	public Wort anwendenAnPositionAuf(int pos, Wort w) {
    return w.ersetzeAnPositionMit(pos, this.rechts);
  }
	
	/** String-Darstellung, die in eine Datei geschrieben und
	 * so wieder gelesen werden kann.
	 * @return Textrepraesentation der Regel
	 */
	 public String toFile() {
	    String init = this.id == null? "" : this.id + " :: ";
	    if (this.rechts.laenge() > 0) {
	      return init + links + " -> " + rechts.toFile();
	    }
	    return init + links + " -> /eps";
	  }
	 
	  @Override
	  public String toString() {
	    String vorne = this.id==null || this.id.equals("")? "" : this.id + " :: ";
	    if (this.rechts.laenge() > 0) {
	      return vorne + links + " -> " + rechts;
	    }
	    return vorne + links + " -> \u03B5";
	  }

	public Nichtterminal getLinks() {
		return links;
	}

	public void setLinks(Nichtterminal links) {
		this.links = links;
	}

	public Wort getRechts() {
		return rechts;
	}

	public void setRechts(Wort rechts) {
		this.rechts = rechts;
	}
	
	@Override
	public KontextfreieRegel clone() {
	  return new KontextfreieRegel(this.links, this.rechts.clone(), this.id);
	}

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, links, rechts);
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    KontextfreieRegel other = (KontextfreieRegel) obj;
    return Objects.equals(id, other.id)
        && Objects.equals(links, other.links)
        && Objects.equals(rechts, other.rechts);
  }

  
}
