package grammatik;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import alphabet.Zeichen;

public class OptimierteGrammatik extends KontextfreieGrammatik{

  /**
   * Es werden alle Regeln entfernt, bei denen ein Nichtterminal
   * auf der rechten Seite zum leeren Wort abgeleitet werden kann
   * und neue Regeln ergaenzt, die die rechte Seite ohne dieses
   * Nichtterminal enthalten. Alle Regeln mit dem leeren Wort auf
   * der rechten Seite werden geloescht.
   * Falls das leere Wort in der Sprache liegt, ist das Ergebnis
   * true sonst false.
   * @return gehoert leeres Wort zu Sprache?
   */
  @Override
  public boolean ohneLeeresWortRegeln() {
    Set<Nichtterminal> nachLeer = this.nachLeeremWortAbleitbar();
    //System.out.println("nachleer0: " + nachLeer);
    int tmp = 0;
    while (tmp != this.regeln.size()) {
      tmp = this.regeln.size();
      //System.out.println("tmp: " + tmp);
      List<KontextfreieRegel> neu = new ArrayList<>();
      for(KontextfreieRegel r: this.regeln) {
        for(Nichtterminal z: nachLeer) {
          //System.out.println("z: " + z);
          List<Integer> positionen = r.getRechts().positionenVon(z);
          for(int i = positionen.size() - 1; i >= 0; i--) {
            KontextfreieRegel reg = new KontextfreieRegel(r.getLinks()
                , r.getRechts().clone().ersetzeAnPositionMit(
                    positionen.get(i), new Wort()));
            if (!this.regeln.contains(reg) && ! neu.contains(reg)) {
              neu.add(reg);
            }
          }         
        }
      }
      this.regeln.addAll(neu);
    }
    for(int i = this.regeln.size() - 1; i >= 0; i--) {
      if (this.regeln.get(i).getRechts().equals(new Wort())) {
        this.regeln.remove(i);
      }
    }
    //System.out.println("nachleer1: " + nachLeer);
    return nachLeer.contains(this.start);
  }
  
  /**
   * Es werden alle Kettenregeln, mit denen ein Nichtterminalzeichen
   * auf ein andreres Nichtterminalzeichen abgeleitet werden kann,
   * entfernt und aequivalente Regeln ohne diese Kette ergaenzt
   * @return this mit gleicher erzeugter Sprache ohne Kettenregeln
   */
  @Override
  public KontextfreieGrammatik entferneKettenregeln() { 
    //System.out.println("entferne Ketten1: " + this);
    List<Paar> kette = new ArrayList<>();
    for(Nichtterminal n: Nichtterminal.alleNichtterminale()) {
      kette.add(new Paar(n, n));
    }
    int tmp = 0;
    while (tmp != kette.size()) {
      tmp = kette.size();
      List<Paar> neu = new ArrayList<>();
      for(Paar p1:kette) {
        for(KontextfreieRegel r: this.regeln) {
          if (r.getLinks() == p1.rechts 
              && r.getRechts().istNichtterminal()) {
            Paar pa = new Paar(p1.links, r.getRechts().alsNichtterminal());
            if(!kette.contains(pa) && !neu.contains(pa)) {
              neu.add(pa);
            }
          }
        }
      }
      kette.addAll(neu);
    }
    //System.out.println("kette: " + kette);
    
    List<KontextfreieRegel> erg = new ArrayList<>();
    for(Paar pa: kette) {
      for(KontextfreieRegel re: this.regeln) {
        if (re.getLinks() == pa.rechts && !re.getRechts().istNichtterminal()) {
          KontextfreieRegel neu = new KontextfreieRegel(pa.links, re.getRechts());
          if(!erg.contains(neu)) {
            erg.add(neu);
          }
//        } else {
//          erg.add(re);
        }
      }
    }
    
    this.regeln = erg;
    
    // System.out.println("entferne Ketten2: " + this);
    return this;
  }
  
  
  /**
   * Es wird eine sprachaeguivalente Grammatik konstruiert, die die 
   * gegebene ersetzt, deren Regeln in Chomsky-Normalform sind
   * @return this, umgeformt in Chomsky-Normalform
   */
  @Override
  public KontextfreieGrammatik inChomskyNormalform() {
    boolean leeresWort = this.ohneLeeresWortRegeln();
    //System.out.println("ohne leeres-Wort-Regeln:\n" + this + "\n");
    this.entferneKettenregeln();
    //System.out.println("ohne Kette:\n" + this + "\n");
    
    Set<Terminal> genutzt = new HashSet<>();
    Map<Terminal, Nichtterminal> ersetzer = new HashMap<>();
    for(Terminal t: Terminal.alleTerminale()) {
      ersetzer.put(t, Nichtterminal.neu());
      this.addNichtterminale(ersetzer.get(t));
    }
    for(KontextfreieRegel reg: this.regeln) {
      Wort neu = new Wort();
      if(reg.getRechts().laenge() > 1) {
        for(Zeichen z: reg.getRechts()) {
          if(z instanceof Nichtterminal) {
            neu.anfuegen(z);
          } else {
            neu.anfuegen(ersetzer.get((Terminal)z));
            genutzt.add((Terminal)z);
          }
        }
        reg.setRechts(neu);
      }
    }
    
    for(Terminal t: genutzt) {
      this.addRegeln(new KontextfreieRegel(ersetzer.get(t), new Wort(t)));
    }
    
    //System.out.println("Terminale ersetzt:\n" + this);
    
    List<KontextfreieRegel> neu = new ArrayList<>();
    for(KontextfreieRegel reg: this.regeln) {
      if (reg.getRechts().laenge() < 3) {
        neu.add(reg);
      } else {
        Nichtterminal hilf = Nichtterminal.neu();
        this.addNichtterminale(hilf);
        Wort rechts = reg.getRechts();
        neu.add(new KontextfreieRegel(reg.getLinks(), new Wort(rechts.at(0), hilf)));
        for(int i = 1 ; i < rechts.laenge() - 2; i++) {
          Nichtterminal hilf2 = Nichtterminal.neu();
          this.addNichtterminale(hilf2);
          neu.add(new KontextfreieRegel(hilf, new Wort(rechts.at(i), hilf2)));
          hilf = hilf2;
        }
        neu.add(new KontextfreieRegel(hilf
            , new Wort(rechts.at(rechts.laenge() - 2)
                , rechts.at(rechts.laenge() - 1))));
      }
    }
    this.regeln = neu;
    
    if(leeresWort) {
      this.addRegeln(new KontextfreieRegel(this.start, new Wort()));
    }
    return this;
  }
}
