package main;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import ausfuehrung.Ableitung;
import grammatik.KontextfreieGrammatik;
import grammatik.KontextfreieRegel;
import semantik.Ableitungsbaum;

public class KontextfreieGrammatikProgrammiert {

  public static void main(String[] args) {
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.setIgnoriereLeerzeichen(true);
    Nichtterminal nX = Nichtterminal.nichtterminal("X");
    Nichtterminal nA = Nichtterminal.nichtterminal("A");
    Nichtterminal nB = Nichtterminal.nichtterminal("B");
    g.addNichtterminale(nX, nA, nB);
    Terminal ta = Terminal.terminal("a");
    Terminal tb = Terminal.terminal("b");
    Terminal tc = Terminal.terminal("c");
    g.addTerminale(ta, tb, tc);
    g.setStart(nX);
    KontextfreieRegel r1 = new KontextfreieRegel(nX, g.stringAlsWort("aaX"));
    KontextfreieRegel r2 = new KontextfreieRegel(nX, g.stringAlsWort("A"));
    KontextfreieRegel r3 = new KontextfreieRegel(nA, g.stringAlsWort("bbA"));
    KontextfreieRegel r4 = new KontextfreieRegel(nA, g.stringAlsWort("B"));
    KontextfreieRegel r5 = new KontextfreieRegel(nB, g.stringAlsWort("ccX"));
    KontextfreieRegel r6 = new KontextfreieRegel(nB, g.stringAlsWort("/eps"));
    g.addRegeln(r1, r2, r3, r4, r5, r6);
    System.out.println(g);
    
    Ableitung abl = g.ableitbar(g.stringAlsWort("aabbcc"));
    System.out.println("Ist aabbcc ableitbar: " + abl.isErfolgreich());
    Ableitungsbaum ablb = Ableitungsbaum.ableitungAlsBaum(abl);
    ablb.linksdurchlauf();
    ablb.visualisieren();  
    
    Ableitung abl2 = g.berechneAbleitung(g.stringAlsWort("aabbcc"));
    System.out.println("\nIst aabbcc ableitbar: " + abl2.isErfolgreich());
    Ableitungsbaum ablb2 = Ableitungsbaum.ableitungAlsBaum(abl2);
    ablb2.linksdurchlauf();
    ablb2.visualisieren();  
  }
}
