package main;

import endlicherAutomat.EndlicherAutomat;
import grammatik.KontextfreieGrammatik;

public class MainDetertministisch {

  public static void main(String[] args) {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % Kommentarmoeglichkeit (geht ohne)
        % a am Ende nichtdeterministisch mit Epsilon
        % Alphabet
        A: a b 
        % Zustaende
        Z: z0 z1 z2
        % Endzustaende
        E: z1 z2
        % Startzustand
        S: z0
        % Ueberfuehrung
        % von mit  nach
          z0  a    z1
        % Uebergang mit Espilon  
          z1  /eps z2
          z2  /eps z0
        % naechste zwei Zeilen nichtdeterministisch  
          z2  a    z1
          z2  a    z2
          z1  b    z0
          z0  b    z0
          z0  a    z0
        """);
    ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "beispielautomat.atm");
    //ea.wortAbarbeiten("abba");
    //System.out.println("akzeptiert: " + ea.akzeptieren("abba"));
    System.out.println("istohneEps: " + ea.istOhneEpsilon());
    System.out.println("istdeterminis : " + ea.istDeterministisch());
    System.out.println("istvollstaend : " + ea.istVollstaendig());
    ea.epsilonEntfernen();
    System.out.println("istohneEps: " + ea.istOhneEpsilon());
    //System.out.println("istvollstaend : " + ea.istVollstaendig());
    //System.out.println("\n" + ea);
    ea.vervollstaendigen();
    //System.out.println("istvollstaend : " + ea.istVollstaendig());
    System.out.println("\n" + ea);
    ea.deterministisch();
    System.out.println("istdeterminis : " + ea.istDeterministisch());
    System.out.println("\n" + ea);
    
    ea.minimieren();
    System.out.println("\n" + ea);
    System.out.println("-------------------------------\n");
    
    ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % Automat zur Minimerung aus der Vorlesung
        A: a b
        Z: z0 z1 z2 z3 z4
        E: z0 z3
        S: z0
        z0 a z1
        z0 b z3
        z1 a z2
        z1 b z4
        z2 a z0
        z2 b z2
        z3 a z4
        z3 b z0
        z4 a z2
        z4 b z4
        """);
    ea.minimieren();
    ea.zeigeMinimierungsmatrix();
    System.out.println(ea);
    ea.zustandsnamenKuerzen();
    System.out.println("\n" + ea);
    KontextfreieGrammatik kfg = ea.alsGrammatik();
    System.out.println("\n" + kfg);
  }
}
