package main;

import alphabet.Wort;
import alphabet.Zeichen;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.Klammern;
import regulaererAusdruck.Leer;
import regulaererAusdruck.Oder;
import regulaererAusdruck.Punkt;
import regulaererAusdruck.RegulaererAusdruck;
import regulaererAusdruck.Stern;

public class MainRegulaererAusdruck {

  public static void main0(String[] args) {
    RegulaererAusdruck re = RegulaererAusdruck.alsAusdruck("(a+(b)*)");
    System.out.println("re: " + re);
    System.out.println("bb: " + re.beinhaltet("bb"));
    System.out.println("aa: " + re.beinhaltet("aa"));
  }
  
  public static void main1(String[] args) {
    RegulaererAusdruck re = new Leer();
    System.out.println("re: " + re);
    re = Zeichen.zeichen("a");
    System.out.println("re: " + re);
    re = new Punkt(re, Zeichen.zeichen("b"), re); // Konkatenation
    System.out.println("re: " + re);
    re = new Klammern(re);
    System.out.println("re: " + re);
    re = new Oder(Zeichen.zeichen("c"), re);
    System.out.println("re: " + re);
    re = new Stern(re);
    System.out.println("re: " + re);    
  }
  
  public static void main(String[] args) {
    RegulaererAusdruck re = RegulaererAusdruck.alsAusdruck("(a+(b)*)");
    EndlicherAutomat ea = re.alsAutomat();
    System.out.println(ea);
    EndlicherAutomat ea2 = new EndlicherAutomat();
    ea2.stringAlsAutomat("""
        % Automat_det
        Z: z0 z1 z2 z3 z4
        E: z0 z3 z4
        S: z0
        A: a b
        z0 /eps z1
        z0 /eps z2
        z1 a z3
        z2 b z4
        z4 b z4
        """);
    System.out.println(ea2.alsRegulaererAusdruck());
    ea.deterministisch().minimieren().zustandsnamenKuerzen();
    ea2.deterministisch().minimieren().zustandsnamenKuerzen();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    if (!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      System.out.println(w + "wird nicht gleichbehandelt");
    } else {
      System.out.println("sind sprachaequivalent\n" + ea);
    }
  }
  
  public static void main3(String[] args) {
    RegulaererAusdruck re = RegulaererAusdruck.alsAusdruck("(a+(b)*)");
    System.out.println("aequivalent: " 
        + re.istAequivalent("((({})* + a) + b(b)*)"));
    RegulaererAusdruck re2 = RegulaererAusdruck.alsAusdruck("(aa+(b)*)");  
    System.out.println("aequivalent: " + re.istAequivalent(re2));
    EndlicherAutomat ea = re.alsAutomat().deterministisch().minimieren();
    EndlicherAutomat ea2 = re2.alsAutomat().deterministisch().minimieren();
    Wort unterschied = ea.nichtGemeinsamesWort(ea2);
    System.out.println("Verhalten unterscheidet sich bei: " + unterschied);
    System.out.println(re + ": " + re.beinhaltet(unterschied));
    System.out.println(re2 + ": " + re2.beinhaltet(unterschied));
  }
  
  public static void main4(String[] args) {
    RegulaererAusdruck re = RegulaererAusdruck.alsAusdruck("(b)*");
    EndlicherAutomat ea = re.alsAutomat().deterministisch().minimieren();
    EndlicherAutomat ea2 = new EndlicherAutomat();
    ea2.stringAlsAutomat("""
        % Automat_det
        Z: z0 z1
        E: z0 
        S: z0
        A: a b
        z0 a z1
        z0 b z0
        z1 a z1
        z1 b z1
        """);
    try {
      System.out.println(ea.istMinimalIsomorph(ea2));
    } catch (IllegalStateException e) {
      System.err.println(e.getMessage());
    }
    re = RegulaererAusdruck.alsAusdruck("((b)* + a{})");
    ea = re.alsAutomat().deterministisch().minimieren();
    System.out.println(ea.istMinimalIsomorph(ea2));
  }
    
}
