package regulaererAusdruck;

import alphabet.Terminal;
import endlicherAutomat.EndlicherAutomat;
import util.Paar;
import zustand.Zustand;

public class Oder extends RegulaererAusdruck {
  private static final long serialVersionUID = 1L;
  private RegulaererAusdruck[] innen;

  public Oder(RegulaererAusdruck... innen) {
    super();
    this.innen = innen;
  }
  
  @Override
  public String toString() {
    String erg ="(";
    int i=0;
    for( ; i<this.innen.length-1; i++) {
      erg += innen[i] + " + ";
    }
    return erg + innen[i] + ")";
  }
  
  @Override
  public EndlicherAutomat alsAutomat() {
    EndlicherAutomat erg = new EndlicherAutomat();
    EndlicherAutomat[] teile = new EndlicherAutomat[this.innen.length];
    Zustand start = Zustand.neu();
    Zustand ende = Zustand.neu();
    erg.addZustand(start, ende);
    erg.setStart(start);
    erg.addEndzustand(ende);
    
    for(int i = 0; i < this.innen.length; i++) {
      teile[i] = innen[i].alsAutomat();
      erg.addEpsilonueberfuehrung(start, teile[i].getStart());
      for(Terminal z: teile[i].getAlphabet()) {
        if(! erg.getAlphabet().contains(z) && !z.toString().equals("{}")) {
          erg.addZeichen(z);
        }
      }
      for(Zustand z: teile[i].getZustaende()) {
        if(! erg.getZustaende().contains(z)) {
          erg.addZustand(z);
        }
      }
      for(Zustand z: teile[i].getEndzustaende()) {
        erg.addEpsilonueberfuehrung(z, ende);
      }
      
      for(Paar<Zustand, Terminal> p: teile[i].getUeber().getFunktion().keySet()) {
        for(Zustand e: teile[i].getUeber().getFunktion().get(p)) {
          erg.addUeberfuehrung(p.getLinks(), p.getRechts(), e);
        }
      }
      for(Zustand z: teile[i].getUeber().getEpsilon().keySet()) {
        for(Zustand e: teile[i].getUeber().getEpsilon().get(z)) {
          erg.addEpsilonueberfuehrung(z, e);
        }
      }
    }
    return erg;
  }
}
