package regulaererAusdruck;

import alphabet.Terminal;
import endlicherAutomat.EndlicherAutomat;
import util.Paar;
import zustand.Zustand;

public class Stern extends RegulaererAusdruck{
  private static final long serialVersionUID = 1L;
  private RegulaererAusdruck innen;

  public Stern(RegulaererAusdruck innen) {
    super();
    this.innen = innen;
  }
  
  @Override
  public String toString() {
    return "(" + this.innen.toString()+")*";
  }
  
  @Override
  public EndlicherAutomat alsAutomat() {
    EndlicherAutomat erg = new EndlicherAutomat();
    EndlicherAutomat teil = innen.alsAutomat();
    Zustand start = Zustand.neu();
    Zustand ende = Zustand.neu();
    erg.addZustand(start, ende);
    erg.addEndzustand(ende);

    for(Terminal z: teil.getAlphabet()) {
      if(! erg.getAlphabet().contains(z) && !z.toString().equals("{}")) {
        erg.addZeichen(z);
      }
    }
    for(Zustand z: teil.getZustaende()) {
      if(! erg.getZustaende().contains(z)) {
        erg.addZustand(z);
      }
    }
    for(Zustand z: teil.getEndzustaende()) {
      erg.addEpsilonueberfuehrung(z, ende);
      erg.addEpsilonueberfuehrung(z, teil.getStart());
    }
   
    for(Paar<Zustand, Terminal> p: teil.getUeber().getFunktion().keySet()) {
      for(Zustand e: teil.getUeber().getFunktion().get(p)) {
        erg.addUeberfuehrung(p.getLinks(), p.getRechts(), e);
      }
    }
    for(Zustand z: teil.getUeber().getEpsilon().keySet()) {
      for(Zustand e: teil.getUeber().getEpsilon().get(z)) {
        erg.addEpsilonueberfuehrung(z, e);
      }
    }
    
    erg.setStart(start);
    erg.addEpsilonueberfuehrung(start, teil.getStart());
    erg.addEpsilonueberfuehrung(start, ende);
    return erg;
  }
}
