package semantik;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import alphabet.Nichtterminal;
import alphabet.Wort;
import ausfuehrung.Ableitung;
import ausfuehrung.Regelnutzung;
import baum.Baumdarstellung;
import baumInterface.Baum;
import grammatik.KontextfreieRegel;

public class Ableitungsbaum implements Baum{
  private KontextfreieRegel kfr; // angewandte Regel
  private boolean istTerminal = false; // nur Terminalzeichen? (Blatt)
  private Wort wort; // abgeleitetes Wort (z. Zt. rechte Seite der Regel)
  private Ableitungsbaum[] weiter; // aus Nichterminalen abgeleitet
   
  private static int pos = 0; // Position in zu bearbeitender Ableitung
  /**
   * Aus der uebergebenen Ableitung wird der zugehoerige Ableitungsbaum
   * berechnet.
   * @param ab zu bearbeitende Ableitung
   * @return aus Ableitung rekonstruierter Ableitungsbaum
   */
  public static Ableitungsbaum ableitungAlsBaum(Ableitung ab) {
    pos = 0;
    Ableitungsbaum tmp = ableitungAlsBaumIntern(ab);
    return tmp;
  }

  private static Ableitungsbaum ableitungAlsBaumIntern(Ableitung ab) {
    Ableitungsbaum erg = new Ableitungsbaum();
    if(ab.size() == 0) {
      return new Ableitungsbaum();
    }
    Regelnutzung r = ab.get(pos); 
    //System.out.println(pos + ": " + r.getRegel());
    erg.kfr = r.getRegel();
    Wort wort = r.getRegel().getRechts();
    erg.wort = new Wort(r.getRegel().getLinks());

    if(wort.laenge() == 0) {
      Ableitungsbaum tmp = new Ableitungsbaum();
      tmp.wort = new Wort();
      tmp.istTerminal = true;
      erg.weiter = new Ableitungsbaum[] {
          tmp
      };
      return erg;
    }
    erg.weiter = new Ableitungsbaum[wort.laenge()];
    //System.out.println(" baum1: " + Arrays.asList(erg.weiter));
    for(int i = 0; i < wort.laenge(); i++) {
      if (wort.at(i) instanceof Nichtterminal) {
        pos++;
        erg.weiter[i] = ableitungAlsBaumIntern(ab);
      }else {
        Ableitungsbaum tmp = new Ableitungsbaum();
        tmp.wort = new Wort(wort.at(i));
        tmp.istTerminal = true;
        erg.weiter[i] = tmp;
      }
    }
    //System.out.println(" baum2: " + Arrays.asList(erg.weiter));
    //System.out.println(" alb: " + erg.wort + " : " + r);
    return erg;
  }
  
  /** Visualisierung des Ableitungsbaums, der von links nach
   * rechts auf der Konsole ausgegeben wird, dabei werden detailliert
   * alle genutzten Regeln mit angegeben.
   */
  public void linksdurchlaufDetailliert() {
    if (this.weiter != null) {
      Wort w = new Wort(this.kfr.getLinks());
      this.linksdurchlaufDetailliert(0, w);
      System.out.println(w);
    }
  }
  
  private void linksdurchlaufDetailliert(int ebene, Wort wort) {   
    if(this.kfr == null) {
      return;
    }
    for( int i = 0; i < ebene; i++) {
      System.out.print("  ");
    }
//    if(this.kfr == null) {
//      return;
//    }
//    if(this.weiter == null) {
//      System.out.println(ebene + " - " + this.wort + " : " + this.kfr + " *");
//      return;
//    }
    System.out.println(ebene + ": " + wort + "  " + this.kfr);
    wort.ersetzenVonMitNummer(this.kfr.getLinks(), this.kfr.getRechts(), 1);
    for(Ableitungsbaum b: this.weiter) {
      if(b != null) {
        b.linksdurchlaufDetailliert(ebene + 1, wort);
      }
    }
  }  
  
  /** Visualisierung des Ableitungsbaums, der von links nach
   * rechts auf der Konsole ausgegeben wird.
   */
  public void linksdurchlauf() {
    if (this.weiter != null) {
      Wort w = new Wort(this.kfr.getLinks());
      this.linksdurchlauf(w);
      System.out.println(w);
    }
  }
  
  private void linksdurchlauf(Wort wort) {   
    if(this.kfr == null) {
      return;
    }

    System.out.print(wort + " -> ");
    wort.ersetzenVonMitNummer(this.kfr.getLinks(), this.kfr.getRechts(), 1);
    for(Ableitungsbaum b: this.weiter) {
      if(b != null) {
        b.linksdurchlauf(wort);
      }
    }
  }
  
  /** Berechnet den zum nr-ten Zeichen der rechten Seite 
   * der angewandten Regel zugehoerigen Ableitungsbaum, Position 0 steht
   * damit fuer das 0-te Zeichen und nicht das erste Nichtterminal;
   * sollen zu den Nichtterminalen gehoerige Baeume bestimmt werden,
   * muss dies ueber Ihrer Position im Wort geschehe z. B.
   *   Reg -> ( Reg1 + Reg2 )
   * dann erfolgt der Zugriff auf den Baum zu Reg1 ueber get(1) und
   * Reg2 ueber get(3).     Die Nummerierung
   * beginnt mit 0. Existiert die Position nicht oder steht an der
   * Position eine Terminalzeichen, wird eine
   * IllegalStateException geworfen. 
   * @param nr Nummer des Zeichens, dessen Baum berechnet werden soll
   * @return zur Position gehoerenden Ableitungsbaum
   */
  public Ableitungsbaum get(int nr) {
    //System.out.println("get " + i + " : " + this);
    if(nr < 0 || nr >= weiter.length) {
      throw new IllegalStateException("gib kein " + nr + "-tes Blatt "
          + "im Ableitungsbaum: " + Arrays.asList(weiter));
    }
    if(weiter[nr] == null) {
      throw new IllegalStateException("gib kein echtes " + nr + "-tes Blatt "
          + "im Ableitungsbaum (null) ");
    }
    return this.weiter[nr];
  }
  
  /** Berechnet den zum nr-ten Nichtterminalzeichen der rechten Seite 
   * der angewandten Regel zugehörigen Ableitungsbaum. Die Nummerierung
   * beginnt mit 0. Existiert die Position nicht, wird eine
   * IllegalStateException geworfen. 
   * @param nr Nummer des Nichtterminalzeichens
   * @return zur Position gehoerenden Ableitungsbaum
   */
  public Ableitungsbaum getItesNichtterminal(int nr) {
    //System.out.println("get " + i + " : " + this);
    int tmp = nr;
    for(int i = 0; i < weiter.length && tmp >= 0; i++) {
      if(weiter[i] != null) {
        if(tmp > 0) {
          tmp--;
        } else {
          return weiter[i];
        }
      }
    }
    throw new IllegalStateException("gib kein " + nr + "-tes Nichtterminal "
          + "im Ableitungsbaum: " + this.wort);
  }

  public KontextfreieRegel getKfr() {
    return kfr;
  }

  public void setKfr(KontextfreieRegel kfr) {
    this.kfr = kfr;
  }

  public boolean isIstTerminal() {
    return istTerminal;
  }

  public void setIstTerminal(boolean istTerminal) {
    this.istTerminal = istTerminal;
  }

  public Wort getWort() {
    return wort;
  }

  public void setWort(Wort wort) {
    this.wort = wort;
  }

  public Ableitungsbaum[] getWeiter() {
    return weiter;
  }

  public void setWeiter(Ableitungsbaum[] weiter) {
    this.weiter = weiter;
  }

//  @Override
//  public int hashCode() {
//    final int prime = 31;
//    int result = 1;
//    result = prime * result + Arrays.hashCode(weiter);
//    result = prime * result + Objects.hash(istTerminal, kfr, wort);
//    return result;
//  }
//
//  @Override
//  public boolean equals(Object obj) {
//    if (this == obj)
//      return true;
//    if (obj == null)
//      return false;
//    if (getClass() != obj.getClass())
//      return false;
//    Ableitungsbaum other = (Ableitungsbaum) obj;
//    return istTerminal == other.istTerminal
//        && Objects.equals(kfr, other.kfr)
//        && Arrays.equals(weiter, other.weiter)
//        && Objects.equals(wort, other.wort);
//  }

  @Override
  public String toString() {
    return "Ableitungsbaum [kfr=" + kfr + ", istTerminal="
        + istTerminal + ", wort=" + wort + ", weiter="
        + Arrays.toString(weiter) + "]";
  }

  
  
  @Override
  public String[] text() {
    Wort w = this.wort; // =this.kfr.getRechts();
    if(w == null) {// z. B. bei erfolglosen Ableitungen moeglich
      return new String[] {""};
    }
    if (w.laenge() == 0) {
      return new String[] {w.toGui()};
    }
    String[] erg = new String[w.laenge()];
    for(int i = 0; i < w.laenge(); i++) {
      erg[i] = w.at(i).toString();
    }
    return erg;
  }
  
  @Override
  public Integer[] docking() {
    Wort w = this.wort; // this.kfr.getRechts();
    if(w.laenge() == 0) {
      return new Integer[] {0};
    }
    List<Integer> pos = new ArrayList<>();
    for(int i = 0; i < w.laenge(); i++) {
      if(w.at(i) instanceof Nichtterminal) {
        pos.add(i);
      }
    } 
    return pos.toArray(new Integer[pos.size()]);
  }

  @Override
  public int anzahlKnoten() {
    if(this.weiter == null) {
      return 0;
    }
    return this.weiter.length;
  }

  @Override
  public boolean istBlatt() {
    return this.istTerminal || this.weiter == null;
  }
  
  @Override
  public Baum getTeilbaum(int position) {
    return this.weiter[position];
  }
  
  public void visualisieren() {
    Baumdarstellung.darstellen(this);
  }
  
  public void zuUMLet() {
    Baumdarstellung.nachUMLet(this);
  }
  
}
