package semantik;

@FunctionalInterface
public interface Berechnung {
  /** Die uebergebene Semantik wird auf den uebergebenen Ableitungsbaum
   * angewandt, wobei der aktuelle Zustand uebergeben wird; dieser
   * Zustand kann in der Methode veraendert werden, das Ergebnis ist der
   * im naechsten Schritt zu bearbeitende Ableitungsbaum
   * @param sem anzuwendende Semantik
   * @param baum Baum, auf den die Semantik angewandt werden soll
   * @param z aktueller Zustand, der veraendert werden kann
   * @return im naechsten Schritt zu bearbeitender Ableitungsbaum
   */
  public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z);
  //public Wert berechnen(Semantik sem, Ableitungsbaum baum, Zustand z);
}
