package semantik;

import java.util.HashMap;
import java.util.Map;

public class Interpretation {
  private Map<String, Wert> belegung;
  private Wert akku;
  
  public Interpretation() {
    this.belegung = new HashMap<>();
  }
  
  public Interpretation set(String s, Integer i) {
    this.belegung.put(s, new Wert(i));
    return this;
  }
  
  public Interpretation set(String s, String i) {
    this.belegung.put(s, new Wert(i));
    return this;
  }
  
  public Interpretation set(String s, boolean i) {
    this.belegung.put(s, new Wert(i));
    return this;
  }
  
  /** Methode gibt den akzuellen Wert des Akkumulators zurueck,
   * das ist entweder eine aktuelle Zahl oder bei einem String die in
   * der Belegung dem Namen zugordnete Zahl. Trifft keiner der beiden
   * Typen zu, wird eine IllegalStateException geworfen.
   * @return aus Akkumulator gelesener Wert
   * @exception IllegalStateException
   */
  public int getWert() {
    if (this.akku.getTyp() == VarTyp.INT) {
      return akku.getIntegerWert();
    }
    if (this.akku.getTyp() == VarTyp.STRING) {
      Wert tmp = this.belegung.get(this.akku.getStringWert());
      if (tmp == null) {
        throw new IllegalStateException("kein Wert fuer Variable "
            + this.akku.getStringWert() + " gefunden");
      }
      return tmp.getIntegerWert();
    }
    throw new IllegalStateException("falscher Zugriffstyp, "
        + "erwartet INT oder STRING, gefunden " + this.akku.getTyp());
  }
  
  public Integer getInt(String s) {
    return this.belegung.get(s).getIntegerWert();
  }
  
  public boolean getBool(String s) {
    return this.belegung.get(s).getBooleanWert();
  }
  
  public String getString(String s) {
    return this.belegung.get(s).getStringWert();
  }

  public Map<String, Wert> getBelegung() {
    return belegung;
  }

  public void setBelegung(Map<String, Wert> belegung) {
    this.belegung = belegung;
  }

  public Wert getAkku() {
    return akku;
  }

  public void setAkku(Wert akku) {
    this.akku = akku;
  }

  @Override
  public String toString() {
    return "Zustand [belegung=" + belegung + ", akku=" + akku + "]";
  }
  
}
