package semantik;

import java.util.HashMap;
import java.util.Map;

import grammatik.KontextfreieRegel;
/** Klasse zur Verwaltung der Semantikregeln, die Regeln der
 * kontextfreien Grammatik zugeordnet werden und zur Ausfuehrung
 * eines Semantik-Schritts (der weitere Schritte beinhalten kann)
 */
public class Semantik {
  private Map<KontextfreieRegel, Berechnung> umsetzung;
  
  public Semantik() {
    this.umsetzung = new HashMap<>();
  }
 
  /** fueht einen Schritt der Semantik fuer den gegebenen Baum, genauer
   * der zur Wurzel gehoerenden Regel aus und nutzt dabei die gegebene 
   * Interpretation
   * @param baum abzuarbeitender Ableitungsbaum
   * @param z aktuelle Interpretation, die veraendert werden kann
   * @return Ergebnis der Anwendung der Berechnung) oft irrelevant,
   *         kann aber z. B. danach abzuarbeitender Baum sein.
   */
  public Ableitungsbaum schritt(Ableitungsbaum baum, Interpretation z) {
    KontextfreieRegel reg = baum.getKfr();
    //System.out.println("Sem: " + reg);
    return this.umsetzung.get(reg).berechnen(this, baum, z);
  }
  
  /** ordnet einer Regel r die Semantik bzw. Berechnung b zu.
   * 
   * @param r Regel fuer die Semantik festgelegt wird
   * @param b zugehoerige Berechnung
   * @return this aktualisiert um neue Semantikregel
   */
  public Semantik umsetzungHinzu(KontextfreieRegel r, Berechnung b) {
    this.umsetzung.put(r, b);
    return this;
  }
}
