package semantik;

import java.util.ArrayList;
import java.util.List;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Wort;
import ausfuehrung.Ableitung;
import grammatik.KontextfreieGrammatik;
import grammatik.KontextfreieRegel;

/** Erzeugt intern eine Grammatik der Basisprogrammiersprache der
 * Lehrveranstaltung und ordnet jeder Regel eine Semantik zu.
 * Die Klasse ermoeglicht so, die Ausfuehrung von Programmen
 * und die Nachvollziehbarkeit von Zustandsaenderungen.
 *
 */
public class SemantikBasissprache implements SemantikProgramm {
  private static KontextfreieGrammatik g; 
  private static Semantik sem;
  private static boolean initialisiert = false;
  
  public SemantikBasissprache() {
    if(!initialisiert) {
      init();
    }
  }

  private static void init() {
    initialisiert = true;
    g = new KontextfreieGrammatik();
    g.setIgnoriereLeerzeichen(true);
    g.addNichtterminale(Nichtterminal.nichtterminal("Ausdruck")
          , Nichtterminal.nichtterminal("Bedingung")
          , Nichtterminal.nichtterminal("Start")
          , Nichtterminal.nichtterminal("Befehl")
          , Nichtterminal.nichtterminal("Sequenz")
          , Nichtterminal.nichtterminal("Variable")
          , Nichtterminal.nichtterminal("ITerm")
          , Nichtterminal.nichtterminal("BTerm")
          , Nichtterminal.nichtterminal("Zahl")
        );
    g.addTerminale(Terminal.terminal("0"), Terminal.terminal("1"), Terminal.terminal("2")
        , Terminal.terminal("3"), Terminal.terminal("("), Terminal.terminal(")") 
        , Terminal.terminal("4"), Terminal.terminal("5"), Terminal.terminal("6")
        , Terminal.terminal("7"), Terminal.terminal("8"), Terminal.terminal("9")
        , Terminal.terminal("+"), Terminal.terminal("-")
        , Terminal.terminal("true") , Terminal.terminal("false")
        , Terminal.terminal("and") , Terminal.terminal("or"), Terminal.terminal("not")
        , Terminal.terminal("<"), Terminal.terminal(">"), Terminal.terminal("==")
        , Terminal.terminal(";"), Terminal.terminal(":=")
        , Terminal.terminal("v") , Terminal.terminal("_"), Terminal.terminal("x")
        , Terminal.terminal("u") , Terminal.terminal("y"), Terminal.terminal("z")
        , Terminal.terminal("while") 
        , Terminal.terminal("if"), Terminal.terminal("else")
        , Terminal.terminal("{") , Terminal.terminal("}")
        );
    g.setStart(Nichtterminal.nichtterminal("Sequenz"));
    
    //Ausdruck -> (Ausdruck) | ITerm+Ausdruck | ITerm-Ausdruck | ITerm
    //ITerm -> Zahl | Variable
    //Zahl -> 0..9 | 0..9Zahl
    Nichtterminal aus = Nichtterminal.nichtterminal("Ausdruck");
    KontextfreieRegel r5 = new KontextfreieRegel(aus, g.stringAlsWort("ITerm+Ausdruck"));
    KontextfreieRegel r6 = new KontextfreieRegel(aus, g.stringAlsWort("ITerm-Ausdruck"));
    KontextfreieRegel r7 = new KontextfreieRegel(aus, g.stringAlsWort("(Ausdruck)"));
    //Ausdruck -> ITerm
    KontextfreieRegel r8 = new KontextfreieRegel(aus, g.stringAlsWort("ITerm"));
    
    Nichtterminal it = Nichtterminal.nichtterminal("ITerm");
    KontextfreieRegel r9 = new KontextfreieRegel(it, g.stringAlsWort("Zahl"));
    KontextfreieRegel r10 = new KontextfreieRegel(it, g.stringAlsWort("Variable"));
    g.addRegeln(r5, r6, r7, r8, r9, r10);
    
    Nichtterminal zahl = Nichtterminal.nichtterminal("Zahl");
    List<KontextfreieRegel> zahlen = new ArrayList<>();
    for(int i = 0; i <= 9; i++) {
      KontextfreieRegel rz1 = new KontextfreieRegel(zahl, g.stringAlsWort("Zahl" + i));
      g.addRegeln(rz1);
      zahlen.add(rz1);
      KontextfreieRegel rz2 = new KontextfreieRegel(zahl, g.stringAlsWort(i+"")); 
      g.addRegeln(rz2);
      zahlen.add(rz2);
    }
    
    Nichtterminal bed = Nichtterminal.nichtterminal("Bedingung");
    Nichtterminal bt = Nichtterminal.nichtterminal("BTerm");
    KontextfreieRegel r11 = new KontextfreieRegel(bt, g.stringAlsWort("true"));
    KontextfreieRegel r12 = new KontextfreieRegel(bt, g.stringAlsWort("false"));
    KontextfreieRegel r13 = new KontextfreieRegel(bed, g.stringAlsWort("BTermandBedingung"));
    KontextfreieRegel r14 = new KontextfreieRegel(bed, g.stringAlsWort("BTermorBedingung"));
    KontextfreieRegel r15 = new KontextfreieRegel(bt, g.stringAlsWort("not(Bedingung)"));
    KontextfreieRegel r16 = new KontextfreieRegel(bt, g.stringAlsWort("Ausdruck<Ausdruck"));
    KontextfreieRegel r17 = new KontextfreieRegel(bt, g.stringAlsWort("Ausdruck>Ausdruck"));
    KontextfreieRegel r18 = new KontextfreieRegel(bt, g.stringAlsWort("Ausdruck==Ausdruck"));
    KontextfreieRegel r19 = new KontextfreieRegel(bed, g.stringAlsWort("(Bedingung)"));
    KontextfreieRegel r20 = new KontextfreieRegel(bed, g.stringAlsWort("BTerm"));
    g.addRegeln(r11, r12, r13, r14, r15, r16, r17, r18, r19, r20);
    
    Nichtterminal seq = Nichtterminal.nichtterminal("Sequenz");
    KontextfreieRegel seq1 = new KontextfreieRegel(seq, g.stringAlsWort("BefehlSequenz"));
    KontextfreieRegel seq2 = new KontextfreieRegel(seq, g.stringAlsWort("Befehl"));
    
    Nichtterminal bef = Nichtterminal.nichtterminal("Befehl");
    KontextfreieRegel bef1 = new KontextfreieRegel(bef, g.stringAlsWort("Variable:=Ausdruck;"));
    KontextfreieRegel bef2 = new KontextfreieRegel(bef, g.stringAlsWort("if(Bedingung){Sequenz}else{Sequenz}"));
    KontextfreieRegel bef3 = new KontextfreieRegel(bef, g.stringAlsWort("while(Bedingung){Sequenz}"));
    
    Nichtterminal var = Nichtterminal.nichtterminal("Variable");
    KontextfreieRegel var1 = new KontextfreieRegel(var, g.stringAlsWort("u"));
    KontextfreieRegel var2 = new KontextfreieRegel(var, g.stringAlsWort("v"));
    KontextfreieRegel var3 = new KontextfreieRegel(var, g.stringAlsWort("_"));
    KontextfreieRegel var4 = new KontextfreieRegel(var, g.stringAlsWort("x"));
    KontextfreieRegel var5 = new KontextfreieRegel(var, g.stringAlsWort("y"));
    KontextfreieRegel var6 = new KontextfreieRegel(var, g.stringAlsWort("z"));
    
    final String[] varnamen = {"u", "v", "x", "y", "z", "_"}; // mit vorher vereinfachen
    KontextfreieRegel[] varz = new KontextfreieRegel[varnamen.length];
    for(int i = 0; i < varnamen.length; i++) {
      varz[i] = new KontextfreieRegel(var, g.stringAlsWort(varnamen[i]+"Zahl"));
    }
    
    g.addRegeln(seq1, seq2, bef1, bef2, bef3, var1, var2, var3, var4, var5, var6);
    g.addRegeln(varz);
    
    Nichtterminal s = Nichtterminal.nichtterminal("Start");
    KontextfreieRegel rs1 = new KontextfreieRegel(s, g.stringAlsWort("Ausdruck"));
    KontextfreieRegel rs2 = new KontextfreieRegel(s, g.stringAlsWort("Bedingung"));
    g.addRegeln(rs1, rs2);
    
    //g.dateiSpeichern("MainSemantik.kfg");
    
    sem = new Semantik();
    
    Berechnung b5 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp + z.getWert()));
        //System.out.println(" 5: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b6 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp - z.getWert()));
        //System.out.println(" 6: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b7 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(1), z);
        //System.out.println(" 7: " + z);
        z.setAkku(new Wert(z.getWert()));
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b13 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        boolean tmp = z.getAkku().getBooleanWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp && z.getAkku().getBooleanWert()));
        //System.out.println(" 13: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b14 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        boolean tmp = z.getAkku().getBooleanWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp || z.getAkku().getBooleanWert()));
        //System.out.println(" 14: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b15 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(!z.getAkku().getBooleanWert()));
        //System.out.println(" 15: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b17 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp > z.getWert()));
        //System.out.println(" 17: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b18 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp == z.getWert()));
        //System.out.println(" 18: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b16 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp < z.getWert()));
        //System.out.println(" 16: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b19 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(1), z);
        z.setAkku(new Wert(z.getAkku().getBooleanWert()));
        //System.out.println(" 19: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b20 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        z.setAkku(new Wert(z.getAkku().getBooleanWert()));
        //System.out.println(" 20: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    
    // bef1 = new KontextfreieRegel(bef, g.stringAlsWort("Variable:=Ausdruck;"));
    Berechnung bbef1 = new Berechnung() {     
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        String name = z.getAkku().getStringWert();
        sem.schritt(baum.get(2), z);
        z.set(name, z.getAkku().getIntegerWert());
        System.out.println(":= :     " + z.getBelegung());
        return baum; 
      }
    };
    
    Berechnung baus8 = new Berechnung() {     
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        return baum; 
      }
    };
    
    Berechnung bseq1 = new Berechnung() {     
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        sem.schritt(baum.get(1), z);
        //System.out.println(" seq1: " + z);
        return baum; 
      }
    };
    
    Berechnung bseq2 = new Berechnung() {     
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        //System.out.println(" seq2: " + z);
        return baum; 
      }
    };
    
    Berechnung bbef2 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(2), z);
        boolean tmp = z.getAkku().getBooleanWert();
        if(tmp) {
          System.out.println("if t:    " + z.getBelegung());
          sem.schritt(baum.get(5), z);
        } else {
          System.out.println("if f:    " + z.getBelegung());
          sem.schritt(baum.get(9), z);
        }
        //System.out.println(" bef2: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung bbef3 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(2), z);
        boolean tmp = z.getAkku().getBooleanWert();
        while(tmp) {
          System.out.println("while t: " + z.getBelegung());
          sem.schritt(baum.get(5), z);
          sem.schritt(baum.get(2), z);
          tmp = z.getAkku().getBooleanWert();
        }
        System.out.println("while f: " + z.getBelegung());
        //System.out.println(" bef3: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    sem.umsetzungHinzu(r5, b5);
    sem.umsetzungHinzu(r6, b6);
    sem.umsetzungHinzu(r7, b7);
    sem.umsetzungHinzu(r8, baus8);
    sem.umsetzungHinzu(r9, (sema, baum, z) -> { 
      sem.schritt(baum.get(0), z);
      //z.setAkku(new Wert(true)); 
      return baum;
    });
    sem.umsetzungHinzu(r10, (sema, baum, z) -> { 
      sem.schritt(baum.get(0), z);
      z.setAkku(new Wert(z.getWert())); 
      return baum;
    });
    for(int i = 0; i <= 19; i = i + 2) {
      sem.umsetzungHinzu(zahlen.get(i)
          , (sema, baum, z) -> {
            //System.out.println(" r: " + baum.getKfr());
            sem.schritt(baum.get(0), z);
            //System.out.println(" w: " + baum.getWort());
            //int val = Integer.parseInt(baum.getWort().at(1).toString());
            int val = Integer.parseInt(baum.get(1).getWort().toString());
            z.setAkku(new Wert(z.getAkku().getIntegerWert() * 10 + val));
            return baum;
      });
      sem.umsetzungHinzu(zahlen.get(i + 1)
          , (sema, baum, z) -> {
            //int val = Integer.parseInt(baum.getWort().at(0).toString());
            int val = Integer.parseInt(baum.get(0).getWort().toString());
            z.setAkku(new Wert(val));
            return baum;
      });
    }
    
    sem.umsetzungHinzu(r11, (sema, baum, z) -> { z.setAkku(new Wert(true)); return baum;});
    sem.umsetzungHinzu(r12, (sema, baum, z) -> { z.setAkku(new Wert(false)); return baum;});
    sem.umsetzungHinzu(r13, b13);
    sem.umsetzungHinzu(r14, b14);
    sem.umsetzungHinzu(r15, b15);
    sem.umsetzungHinzu(r16, b16);
    sem.umsetzungHinzu(r17, b17);
    sem.umsetzungHinzu(r18, b18);
    sem.umsetzungHinzu(r19, b19);
    sem.umsetzungHinzu(r20, b20);
    
    sem.umsetzungHinzu(rs1, (sema, baum, z) -> {return baum.get(0);});
    sem.umsetzungHinzu(rs2, (sema, baum, z) -> {return baum.get(0);});
    
    sem.umsetzungHinzu(var1, (sema, baum, z) -> { z.setAkku(new Wert("u")); return baum;});
    sem.umsetzungHinzu(var2, (sema, baum, z) -> { z.setAkku(new Wert("v")); return baum;});
    //sem.umsetzungHinzu(var3, (sema, baum, z) -> { z.setAkku(new Wert("w")); return baum;});
    sem.umsetzungHinzu(var3, (sema, baum, z) -> { z.setAkku(new Wert("_")); return baum;});
    sem.umsetzungHinzu(var4, (sema, baum, z) -> { z.setAkku(new Wert("x")); return baum;});
    sem.umsetzungHinzu(var5, (sema, baum, z) -> { z.setAkku(new Wert("y")); return baum;});
    sem.umsetzungHinzu(var6, (sema, baum, z) -> { z.setAkku(new Wert("z")); return baum;});
    
    for(int i = 0; i < varnamen.length; i++) {
      sem.umsetzungHinzu(varz[i], (sema, baum, z) -> { 
        sem.schritt(baum.get(1), z);
        z.setAkku(new Wert(baum.get(0).getWort().toString() + z.getWert())); 
        return baum;});
    }
    
    sem.umsetzungHinzu(bef1, bbef1);
    sem.umsetzungHinzu(bef2, bbef2);
    sem.umsetzungHinzu(bef3, bbef3);
    sem.umsetzungHinzu(seq1, bseq1);
    sem.umsetzungHinzu(seq2, bseq2);
  }
  
  @Override
  public Interpretation ausfuehren(String programm) {
    Wort w = g.stringAlsWort(programm);
    Ableitung ab = g.berechneAbleitung(w);
    if(!ab.isErfolgreich()) {
      System.err.println("Syntax-Fehler, ableitbar:" + ab.getAbgeleitet());
      return null;
    }
    Ableitungsbaum abl = Ableitungsbaum.ableitungAlsBaum(ab);
    Interpretation zu = new Interpretation();
    sem.schritt(abl,zu);
    return zu;
  }
}
