package semantik;

import alphabet.Wort;
import ausfuehrung.Ableitung;
import grammatik.KontextfreieGrammatik;

/** Erzeugt intern eine Grammatik der Basisprogrammiersprache der
 * Lehrveranstaltung und ordnet jeder Regel eine Semantik zu.
 * Die Klasse ermoeglicht so, die Ausfuehrung von Programmen
 * und die Nachvollziehbarkeit von Zustandsaenderungen.
 *
 */
public class SemantikBasisspracheDateiSingle implements SemantikProgramm {
  private static KontextfreieGrammatik g; 
  private static Semantik sem;
  private static boolean initialisiert = false;
  
  public SemantikBasisspracheDateiSingle() {
    if(!initialisiert) {
      init();
    }
  }

  private static void init() {
    initialisiert = true;
    g = new KontextfreieGrammatik();
    g.dateiEinlesen("beispiele" + util.Util.FS + "kontextfreiegrammatiken" 
        + util.Util.FS + "ProgspracheBasisSingle.kfg");
    System.out.println(g);
    sem = new Semantik();
    
    Berechnung b5 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp + z.getWert()));
        //System.out.println(" 5: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b6 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp - z.getWert()));
        //System.out.println(" 6: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b7 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(1), z);
        //System.out.println(" 7: " + z);
        z.setAkku(new Wert(z.getWert()));
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b13 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        boolean tmp = z.getAkku().getBooleanWert();
        sem.schritt(baum.get(4), z);
        z.setAkku(new Wert(tmp && z.getAkku().getBooleanWert()));
        //System.out.println(" 13: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b14 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        boolean tmp = z.getAkku().getBooleanWert();
        sem.schritt(baum.get(3), z);
        z.setAkku(new Wert(tmp || z.getAkku().getBooleanWert()));
        //System.out.println(" 14: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b15 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(4), z);
        z.setAkku(new Wert(!z.getAkku().getBooleanWert()));
        //System.out.println(" 15: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b17 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp > z.getWert()));
        //System.out.println(" 17: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b18 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(3), z);
        z.setAkku(new Wert(tmp == z.getWert()));
        //System.out.println(" 18: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b16 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        int tmp = z.getWert();
        sem.schritt(baum.get(2), z);
        z.setAkku(new Wert(tmp < z.getWert()));
        //System.out.println(" 16: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b19 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(1), z);
        z.setAkku(new Wert(z.getAkku().getBooleanWert()));
        //System.out.println(" 19: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung b20 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        z.setAkku(new Wert(z.getAkku().getBooleanWert()));
        //System.out.println(" 20: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    
    // bef1 = new KontextfreieRegel(bef, g.stringAlsWort("Variable:=Ausdruck;"));
    Berechnung bbef1 = new Berechnung() {     
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        String name = z.getAkku().getStringWert();
        sem.schritt(baum.get(3), z);
        z.set(name, z.getAkku().getIntegerWert());
        System.out.println(":= :     " + z.getBelegung());
        return baum; 
      }
    };
    
    Berechnung baus8 = new Berechnung() {     
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        return baum; 
      }
    };
    
    Berechnung bseq1 = new Berechnung() {     
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        sem.schritt(baum.get(1), z);
        //System.out.println(" seq1: " + z);
        return baum; 
      }
    };
    
    Berechnung bseq2 = new Berechnung() {     
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(0), z);
        //System.out.println(" seq2: " + z);
        return baum; 
      }
    };
    
    Berechnung bbef2 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(3), z);
        boolean tmp = z.getAkku().getBooleanWert();
        if(tmp) {
          System.out.println("if t:    " + z.getBelegung());
          sem.schritt(baum.get(6), z);
        } else {
          System.out.println("if f:    " + z.getBelegung());
          sem.schritt(baum.get(13), z);
        }
        //System.out.println(" bef2: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    Berechnung bbef3 = new Berechnung() {
      
      @Override
      public Ableitungsbaum berechnen(Semantik sem, Ableitungsbaum baum, Interpretation z) {
        sem.schritt(baum.get(6), z);
        boolean tmp = z.getAkku().getBooleanWert();
        while(tmp) {
          System.out.println("while t: " + z.getBelegung());
          sem.schritt(baum.get(9), z);
          sem.schritt(baum.get(6), z);
          tmp = z.getAkku().getBooleanWert();
        }
        System.out.println("while f: " + z.getBelegung());
        //System.out.println(" bef3: " + z);
        return baum; // evtl auf return verzichten oder sogar int zurueck?
      }
    };
    
    sem.umsetzungHinzu(g.regelZuId("r03_0"), b5);
    sem.umsetzungHinzu(g.regelZuId("r03_1"), b6);
    sem.umsetzungHinzu(g.regelZuId("r03_2"), b7);
    sem.umsetzungHinzu(g.regelZuId("r03_3"), baus8);
    sem.umsetzungHinzu(g.regelZuId("r04_0"), (sema, baum, z) -> { 
      sem.schritt(baum.get(0), z);
      return baum;
    });
    sem.umsetzungHinzu(g.regelZuId("r04_1"), (sema, baum, z) -> { 
      sem.schritt(baum.get(0), z);
      z.setAkku(new Wert(z.getWert())); 
      return baum;
    });
    for(int i = 0; i <= 19; i = i + 2) {
      sem.umsetzungHinzu(g.regelZuId("r05_" + i)
          , (sema, baum, z) -> {
            //System.out.println(" r: " + baum.getKfr());
            sem.schritt(baum.get(0), z);
            //System.out.println(" w: " + baum.getWort());
            //int val = Integer.parseInt(baum.getWort().at(1).toString());
            int val = Integer.parseInt(baum.get(1).getWort().toString());
            z.setAkku(new Wert(z.getAkku().getIntegerWert() * 10 + val));
            return baum;
      });
      sem.umsetzungHinzu(g.regelZuId("r05_" + (i + 1))
          , (sema, baum, z) -> {
            //int val = Integer.parseInt(baum.getWort().at(0).toString());
            int val = Integer.parseInt(baum.get(0).getWort().toString());
            z.setAkku(new Wert(val));
            return baum;
      });
    }
    
    sem.umsetzungHinzu(g.regelZuId("r06_0"), (sema, baum, z) -> { z.setAkku(new Wert(true)); return baum;});
    sem.umsetzungHinzu(g.regelZuId("r06_1"), (sema, baum, z) -> { z.setAkku(new Wert(false)); return baum;});
    sem.umsetzungHinzu(g.regelZuId("r07_0"), b13);
    sem.umsetzungHinzu(g.regelZuId("r07_1"), b14);
    sem.umsetzungHinzu(g.regelZuId("r06_2"), b15);
    sem.umsetzungHinzu(g.regelZuId("r06_3"), b16);
    sem.umsetzungHinzu(g.regelZuId("r06_4"), b17);
    sem.umsetzungHinzu(g.regelZuId("r06_5"), b18);
    sem.umsetzungHinzu(g.regelZuId("r07_2"), b19);
    sem.umsetzungHinzu(g.regelZuId("r07_3"), b20);
    
    sem.umsetzungHinzu(g.regelZuId("r08_0"), (sema, baum, z) -> { 
    	sem.schritt(baum.get(0), z);
    	// z.setAkku(new Wert(baum.get(0).getWort().toString())); 
    	//System.out.println(" r08_0" + ": " + baum.getWort() + " _ " + z.getAkku());
    	return baum;
    });
    sem.umsetzungHinzu(g.regelZuId("r08_1"), (sema, baum, z) -> { 
      sem.schritt(baum.get(0), z);
      String s1 = z.getAkku().getStringWert();
      sem.schritt(baum.get(1), z);
      String s2 = z.getAkku().getStringWert();
      z.setAkku(new Wert(s1 + s2));
      return baum;
    });
    String[] zeichen = {"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "_"};
    for(int i = 0 ; i < zeichen.length; i++) {
    	final int tmp = i;
    	sem.umsetzungHinzu(g.regelZuId("r09_" + i), (sema, baum, z) -> { 
    		z.setAkku(new Wert(zeichen[tmp])); 
    		//System.out.println(" r09_" + tmp + ": " + baum.getWort() + " _ " + z.getAkku());
    		return baum;
    	});
    }
    sem.umsetzungHinzu(g.regelZuId("r10_0"), (sema, baum, z) -> { 
    	z.setAkku(new Wert("")); 
    	//System.out.println(" r10_0" + ": " + baum.getWort() + " _ " + z.getAkku());
    	return baum;
    });
    sem.umsetzungHinzu(g.regelZuId("r10_1"), (sema, baum, z) -> { 
      sem.schritt(baum.get(0), z);
    	// String s1 = baum.get(0).getWort().toString();
      //System.out.println("1 r10_1" + ": " + baum.getWort() + " _ " + z.getAkku());
    	String s1 = z.getAkku().getStringWert();
    	sem.schritt(baum.get(1), z);
    	//System.out.println("2 r10_1" + ": " + baum.getWort() + " _ " + z.getAkku());
    	//String s2 = baum.get(1).getWort().toString();
    	String s2 = z.getAkku().getStringWert();
    	z.setAkku(new Wert(s1 + s2));
    	//System.out.println(" r10_1" + ": " + baum.getWort() + " _ " + z.getAkku());
    	return baum;
    });
    sem.umsetzungHinzu(g.regelZuId("r10_2"), (sema, baum, z) -> { 
      sem.schritt(baum.get(0), z);
      String s1 = z.getAkku().getIntegerWert() + "";
      sem.schritt(baum.get(1), z);
      String s2 = z.getAkku().getStringWert();
    	z.setAkku(new Wert(s1 + s2)); 
    	//System.out.println(" r10_2" + ": " + baum.getWort() + " _ " + z.getAkku());
    	return baum;
    });
    
    sem.umsetzungHinzu(g.regelZuId("r02_0"), bbef1);
    sem.umsetzungHinzu(g.regelZuId("r02_1"), bbef2);
    sem.umsetzungHinzu(g.regelZuId("r02_2"), bbef3);
    sem.umsetzungHinzu(g.regelZuId("r01_0"), bseq1);
    sem.umsetzungHinzu(g.regelZuId("r01_1"), bseq2);
  }
  
  @Override
  public Interpretation ausfuehren(String programm) {
    Wort w = g.stringAlsWort(programm);
    Ableitung ab = g.berechneAbleitung(w);
    if(!ab.isErfolgreich()) {
      System.err.println("Syntax-Fehler, ableitbar:" + ab.getAbgeleitet());
      return null;
    }
    Ableitungsbaum abl = Ableitungsbaum.ableitungAlsBaum(ab);
    //abl.visualisieren();
    Interpretation zu = new Interpretation();
    sem.schritt(abl,zu);
    return zu;
  }
}
