package semantik;

public class Wert {
	//private VarTyp typ;
	private boolean booleanWert;
	private int integerWert;
	private String stringWert;
	private VarTyp typ;

	public Wert() {
	  
	}
	
	public Wert(boolean b) {
		this.typ = VarTyp.BOOL;
		this.booleanWert = b;
	}

	public Wert(int i) {
		this.typ = VarTyp.INT;
		this.integerWert = i;
	}

	public Wert(String s) {
		this.typ = VarTyp.STRING;
		this.stringWert = s;
	}


	public VarTyp getTyp() {
		return typ;
	}

	public void setTyp(VarTyp typ) {
		this.typ = typ;
	}

	public boolean getBooleanWert() {
		if (this.typ != VarTyp.BOOL) {
			throw new IllegalArgumentException("falscher Zugriffstyp, erwartet " + this.typ + " abgefragt als BOOL");
		}
		return booleanWert;
	}

	public void setBooleanWert(boolean booleanWert) {
		this.typ = VarTyp.BOOL;
		this.booleanWert = booleanWert;
	}

	public int getIntegerWert() {
		if (this.typ != VarTyp.INT) {
			throw new IllegalArgumentException("falscher Zugriffstyp, erwartet " + this.typ + " abgefragt als INT");
		}
		return integerWert;
	}

	public void setIntegerWert(int integerWert) {
		this.typ = VarTyp.INT;
		this.integerWert = integerWert;
	}

	public String getStringWert() {
		if (this.typ != VarTyp.STRING) {
			throw new IllegalArgumentException("falscher Zugriffstyp, erwartet " + this.typ + " abgefragt als STRING");
		}
		return stringWert;
	}

	public void setStringWert(String stringWert) {
		this.typ = VarTyp.STRING;
		this.stringWert = stringWert;
	}

	@Override
	public String toString() {
		switch (this.typ) {
		case BOOL:
			return "" + this.booleanWert;
		case INT:
			return "" + this.integerWert;
		default:
			return this.stringWert;
		}
	}

}
