package skript;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class AutomatenPruefen {
  public static void main0(String...strings) {
    EndlicherAutomat ausgangsautomat = new EndlicherAutomat();
    ausgangsautomat.stringAlsAutomat("""
        A: a b
        Z: z0 z1 z2
        E: z2
        S: z0
        z0 a z0
        z0 a z1
        z1 b z2
        """);
    
    EndlicherAutomat zielautomat = new EndlicherAutomat();
    zielautomat.stringAlsAutomat("""
        A: a b
        Z: z0 z1 z2 z3
        E: z2
        S: z0
        z0 a z1
        z0 b z3
        z1 a z1
        z1 b z2
        z2 a z3
        z2 b z3
        z3 a z3
        z3 b z3
        """);

    // Da die Aufgabe "deterministisch machen" ist, ist dies zu pruefen
    if(!zielautomat.istDeterministisch()) {
      System.out.println("leider nicht deterministisch");
    }    
    
    // Automaten fuer Vergleich vorbereiten
    ausgangsautomat.deterministisch().minimieren();
    zielautomat.deterministisch().minimieren();
    //boolean erg = ausgangsautomat.istMinimalIsomorph(zielautomat);
    boolean erg = ausgangsautomat.istSprachaequivalent(zielautomat);
       
    Wort w = null;
    String text = "OK";
    if(!erg) {
      w = ausgangsautomat.nichtGemeinsamesWort(zielautomat);
      text = w + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + zielautomat.akzeptieren(w) + " korrekt:" 
        + ausgangsautomat.akzeptieren(w);
    }
    System.out.println(text);
  }
  
  public static void main(String...strings) {
    EndlicherAutomat ausgangsautomat = new EndlicherAutomat();
    ausgangsautomat.stringAlsAutomat("""
        A: a b
        Z: z0 z1 z2
        E: z2
        S: z0
        z0 a z0
        z0 a z1
        z1 b z2
        """);
    
    EndlicherAutomat zielautomat = RegulaererAusdruck.alsAusdruck("a(a)*b")
        .alsAutomat().deterministisch().minimieren();
    
    // Automaten fuer Vergleich vorbeiten
    ausgangsautomat.deterministisch().minimieren();
    zielautomat.deterministisch().minimieren();  // hier unnoetig
    boolean erg = ausgangsautomat.istMinimalIsomorph(zielautomat);
//    boolean erg = ausgangsautomat.istIsomorph(zielautomat);
       
    Wort w = null;
    String text = "OK";
    if(!erg) {
      w = ausgangsautomat.nichtGemeinsamesWort(zielautomat);
      text = w + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + zielautomat.akzeptieren(w) + " korrekt:" 
        + ausgangsautomat.akzeptieren(w);
    }
    System.out.println(text);
  }
}
