package skript;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import grammatik.KontextfreieGrammatik;
import zustand.Zustand;

public class SprachePruefen {
  private KontextfreieGrammatik meineLoesung;
  
  @BeforeEach
  public void setUp() throws Exception {
    // zur Sicherheit aufraeumen
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    
    String meineGrammatik =
        """
        N: A B
        T: a b 
        S: A
        A -> B | a
        B -> b 
        B -> /eps
        """;
    
    this.meineLoesung = new KontextfreieGrammatik();
    this.meineLoesung.stringAlsGrammatik(meineGrammatik);
  }
  
  // Bei strings markante Worte der Sprache eintragen
  @ParameterizedTest
  @ValueSource(
      strings = { "", "b", "a"})
  public void testOK(String korrektesWort) {
    boolean erg = this.meineLoesung.ableitbar(korrektesWort);
    Assertions.assertTrue(erg, "\"" + korrektesWort + "\""
        + " sollte ableitbar sein in\n");
  }

  //Bei strings markante Worte eintragen, die nicht zur Sprache gehoeren
  @ParameterizedTest
  @ValueSource(
      strings = { "aa", "bb", "ab", "ba", "aaa", "aba", "bbb"})
  public void testNicht(String falschesWort) {
    boolean erg = this.meineLoesung.ableitbar(falschesWort);
    Assertions.assertFalse(erg, "\"" + falschesWort + "\""
        + " sollte nicht ableitbar sein in\n");
  }
  
  @Test
  public void testInChomskyNormalform() {
    Assertions.assertTrue(this.meineLoesung.istInChomskyNormalform());
  }
  
  @Test
  public void testIsRechtslinear() {
    Assertions.assertTrue(this.meineLoesung.istRechtslinear());
  }
}
