package skript;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import endlicherAutomat.EndlicherAutomat;
import zustand.Zustand;

public class SprachePruefenAutomat {
  private EndlicherAutomat ea = new EndlicherAutomat();;
  
  @BeforeEach
  public void setUp() throws Exception {
    // zur Sicherheit aufraeumen
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();

    ea.stringAlsAutomat("""
        Z: z1 z2 z3 z4
        E: z3
        S: z1
        A: a b 
        z1 a z2
        z1 b z2
        z2 a z3
        z2 a z4
        z2 b z3
        """);
  }
   
  @ParameterizedTest
  @ValueSource(
      strings = { "aa", "ba", "aa", "bb"})
  public void testAutOK(String korrektesWort) {
    boolean erg = this.ea.akzeptieren(korrektesWort);
    Assertions.assertTrue(erg, "\"" + korrektesWort + "\""
        + " sollte akzeptierbar sein in\n");
  }

  //Bei strings markante Worte eintragen, die nicht zur Sprache gehoeren
  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "b", "aab", "bab", "bba", "bbb", "aaa", "bbbaa"})
  public void testAutNicht(String falschesWort) {
    boolean erg = this.ea.akzeptieren(falschesWort);
    Assertions.assertFalse(erg, "\"" + falschesWort + "\""
        + " sollte nicht akzeptierbar sein in\n");
  }
}
