package skript;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import turingMaschine.TuringMaschine;
import zustand.Zustand;

public class SprachePruefenTM {
  private TuringMaschine tm = new TuringMaschine();
  
  @BeforeEach
  public void setUp() throws Exception {
    // zur Sicherheit aufraeumen
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();

    tm.stringAlsTuringMaschine("""
        % Zustaende
        Z: Start z1 S
        % Alphabet, Leerzeichen # automatisch dabei
        A: a b
        % Start
        S: Start
        % Ueberfuehrungsfunktion
        Start #   z1 # L
        z1    a   z1 a L
        z1    #   S  # S
        """);
  }
   
  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "aa", "aaa"})
  public void testTMOK(String korrektesWort) {
    boolean erg = this.tm.akzeptieren(korrektesWort);
    Assertions.assertTrue(erg, "\"" + korrektesWort + "\""
        + " sollte akzeptierbar sein in\n");
  }

  //Bei strings markante Worte eintragen, die nicht zur Sprache gehoeren
  @ParameterizedTest
  @ValueSource(
      strings = { "b", "ab", "aab", "bb", "aaab", "aba", "bbb"})
  public void testTMNicht(String falschesWort) {
    boolean erg = this.tm.akzeptieren(falschesWort);
    Assertions.assertFalse(erg, "\"" + falschesWort + "\""
        + " sollte nicht akzeptierbar sein in\n");
  }
}
