package test.alphabet;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Experimente;
import alphabet.Wort;
import alphabet.Zeichen;

public class ExperimenteTest {
  
  private Experimente sut;
  
  @BeforeEach
  public void setUp() {
    this.sut = null; // hier z. B. new ExperimenteImpl();
    Zeichen.reset(); // Erstellung des Alphabets
    String[] zeichen = {"a", "b", "c", "d", "e", "f", "g", "h"
        ,"i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s"
        ,"t", "u", "v", "w", "x", "y", "z"};
    for(String z: zeichen) {
      Zeichen.zeichen(z);
    }
  }

  @Test
  public void testUmdrehen1() {
    Wort w = Wort.stringAlsWort("");
    Wort erg = this.sut.umdrehen(w);
    Assertions.assertEquals(w, erg);
  }
  
  @Test
  public void testUmdrehen2() {
    Wort w = Wort.stringAlsWort("a");
    Wort erg = this.sut.umdrehen(w);
    Assertions.assertEquals(w, erg);
  }
  
  @Test
  public void testUmdrehen3() {
    Wort w = Wort.stringAlsWort("ab");
    Wort erg = this.sut.umdrehen(w);
    Assertions.assertEquals(Wort.stringAlsWort("ba"), erg);
  }
  
  @Test
  public void testUmdrehen4() {
    Wort w = Wort.stringAlsWort("abcd");
    Wort erg = this.sut.umdrehen(w);
    Assertions.assertEquals(Wort.stringAlsWort("dcba"), erg);
  }
  
  @Test
  public void testVorkommenVonIn1() {
    Zeichen z = Zeichen.zeichen("a");
    Wort w = Wort.stringAlsWort("");
    int erg = this.sut.vorkommenVonIn(z, w);
    Assertions.assertEquals(0, erg);
  }
  
  @Test
  public void testVorkommenVonIn2() {
    Zeichen z = Zeichen.zeichen("a");
    Wort w = Wort.stringAlsWort("bbcdf");
    int erg = this.sut.vorkommenVonIn(z, w);
    Assertions.assertEquals(0, erg);
  }
  
  @Test
  public void testVorkommenVonIn3() {
    Zeichen z = Zeichen.zeichen("a");
    Wort w = Wort.stringAlsWort("djgfja");
    int erg = this.sut.vorkommenVonIn(z, w);
    Assertions.assertEquals(1, erg);
  }
  
  @Test
  public void testVorkommenVonIn4() {
    Zeichen z = Zeichen.zeichen("a");
    Wort w = Wort.stringAlsWort("agjhdgdfjakjhdkjghgfda");
    int erg = this.sut.vorkommenVonIn(z, w);
    Assertions.assertEquals(3, erg);
  }
  
  @Test
  public void testEntfernenVonIn1() {
    Zeichen z = Zeichen.zeichen("a");
    Wort w = Wort.stringAlsWort("");
    Wort erg = this.sut.entfernenVonIn(z, w);
    Assertions.assertEquals(w, erg);
  }
  
  @Test
  public void testEntfernenVonIn2() {
    Zeichen z = Zeichen.zeichen("a");
    Wort w = Wort.stringAlsWort("bc");
    Wort erg = this.sut.entfernenVonIn(z, w);
    Assertions.assertEquals(w, erg);
  }
  
  @Test
  public void testEntfernenVonIn3() {
    Zeichen z = Zeichen.zeichen("a");
    Wort w = Wort.stringAlsWort("abba");
    Wort erg = this.sut.entfernenVonIn(z, w);
    Assertions.assertEquals(Wort.stringAlsWort("bb"), erg);
  }
  
}
