package test.alphabet;

import java.io.BufferedReader;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LoesungTest {
  private final String DATEI ="beispiele" + util.Util.FS + "Loesung.txt";
  
  private String leseLoesung() {
    File file = new File(DATEI);
    System.out.println(file.getAbsolutePath());
    if (file.exists() && file.canRead()) {
      Path path = Paths.get(DATEI);
      try (BufferedReader reader = Files
          .newBufferedReader(path, Charset.forName("UTF-8"))) {
        String currentLine = null;
        StringBuilder sb = new StringBuilder();
        while ((currentLine = reader.readLine()) != null) {
          sb.append(currentLine);         
        }
        return sb.toString();
      } catch(Exception e) {
        throw new IllegalArgumentException("FEHLER: " + DATEI 
            + " existiert: " + file.exists()
            + " lesbar: " + file.canRead()
            + ", Meldung: " + e
        );
      }
    } else {
      throw new IllegalArgumentException("FEHLER: " + DATEI 
          + " existiert: " + file.exists()
          + " lesbar: " + file.canRead());
    }
  }
  
  @Test
  public void testeLoesung() {
    String loesung = this.leseLoesung();
    Assertions.assertEquals("HUI", loesung
        , " Erwartete Loessung HUI, gefunden: " + loesung);
  }

}
