package test.alphabet;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Nichtterminal;
import alphabet.Terminal;
//import alphabet.Wort;
import alphabet.Zeichen;
import grammatik.KontextfreieGrammatik;
import zustand.Zustand;

public class TerminalTest {
  
  @BeforeEach
  public void setup() {
    Zustand.reset();
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
  }

  @Test
  public void testAlleWorte() {
    String grammatik = // nur Beispiel zur Fuellung der Terminale
        """
        %ignorespaces
        N: Start A B
        T: a b c
        S: Start
        Start -> AA | BB       
        A-> aA | cB | a        
        B -> aB | cA  
        """;
    KontextfreieGrammatik g = new KontextfreieGrammatik();
    g.stringAlsGrammatik(grammatik);
    Assertions.assertEquals(121, Terminal.alleWorteBisLaenge(4).size()
        ,Terminal.alleWorteBisLaenge(4).toString());
  }
}
