package test.alphabet;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import alphabet.Zeichen;

public class ZeichenTest {
  
  @BeforeEach
  public void setUp() {
    Zeichen.reset();
  }

  @Test
  public void testNeuesZeichen() {
    Zeichen z = Zeichen.zeichen("blubb");
    Assertions.assertEquals("blubb", z.getZeichen());
  }
  
  @Test
  public void testGleichesZeichen() {
    Zeichen z = Zeichen.zeichen("bl");
    Zeichen z2 = Zeichen.zeichen("bl");
    Assertions.assertSame(z, z2);
  }
  
  @Test
  public void testNichtGleichesZeichen() {
    Zeichen z = Zeichen.zeichen("bl");
    Zeichen z2 = Zeichen.zeichen("bm");
    Assertions.assertNotEquals(z, z2);
  }
  
  @Test
  public void testIllegalerPraefix1() {
    try {
      Zeichen z = Zeichen.zeichen("bl");
      Zeichen z2 = Zeichen.zeichen("b");
      Assertions.fail(z2 + " darf nicht erzeugt werden, "
          + "da Praefix von " + z);
    } catch (IllegalStateException e) {     
    }
  }
  
  @Test
  public void testIllegalerPraefix2() {
    try {
      Zeichen z = Zeichen.zeichen("b");
      Zeichen z2 = Zeichen.zeichen("bl");
      Assertions.fail(z2 + " darf nicht erzeugt werden, da " + z 
          + " Praefix davon ist");
    } catch (IllegalStateException e) {     
    }
  }
  
  @Test
  public void testSpace1() {
    Assertions.assertFalse(Zeichen.istZeichen(" "));
    Assertions.assertFalse(Zeichen.istZeichen("/space"));
    Zeichen z = Zeichen.zeichen(" ");
    Zeichen z2 = Zeichen.zeichen("/space");
    Assertions.assertSame(z, z2);
  }
  
  @Test
  public void testSpace2() {
    Assertions.assertFalse(Zeichen.istZeichen(" "));
    Assertions.assertFalse(Zeichen.istZeichen("/space"));
    Zeichen z = Zeichen.zeichen("/space");
    Zeichen z2 = Zeichen.zeichen(" ");
    System.out.println(z.hashCode()  + " : " + z2.hashCode());
    Assertions.assertSame(z, z2);
    Assertions.assertTrue(Zeichen.istZeichen(" "));
    Assertions.assertTrue(Zeichen.istZeichen("/space"));
  }
  
  @Test
  public void testReset() {
    Zeichen.zeichen("bl");
    Zeichen.zeichen("bm");
    Zeichen.reset();
    Assertions.assertFalse(Zeichen.istZeichen("bl"));
    Assertions.assertFalse(Zeichen.istZeichen("bm"));
  }

}
