package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class AusdruckAusAutomat3Test {
  @Test
  public void testAusdruckausAutomat() {
    
    /**** Regulaeren Ausdruck hier eintragen ****/
    
    String ausdruck = "(({})* + a(((((a+b)+ba)+aba)+baa))*((b+ab)+ba))"
        ;
    System.out.println(ausdruck);
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % Automat_det
        Z: z0 z1 z2 z3
        E: z0
        S: z0
        A: a b
        z0 a z3
        z1 b z0
        z2 a z0
        z3 a z3
        z3 b z3
        z3 b z0
        z3 a z1
        z3 b z2
        """);
    ea.deterministisch().minimieren();
    EndlicherAutomat ea2 = RegulaererAusdruck.alsAusdruck(ausdruck).alsAutomat().deterministisch().minimieren();
    
    ea2.zustandsnamenKuerzen();
    System.out.println(ea2);
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      System.out.println(ea);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea2.akzeptieren(w) + " korrekt:" 
        + ea.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
