package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class AusdruckAusAutomatWiederholungTest {
  @Test
  public void testAusdruckausAutomat() {
    
    /**** Regulaeren Ausdruck hier eintragen ****/
    
    String ausdruck = "(a+a(ba)*((b+ba)+({})*))"
        ;
    String a0 = "((a+b)+a(ba)*b(a+b))";
    String a1 = "((a+b)+aa)(ba)*";
    String a2 = " (((a + a(a+b)) +" + a1 + "b(a+b)))*";
    ausdruck = "(a(ba)* +"
          + a0
          + a2
          + a1 +")";
    //ausdruck = a2;
    System.out.println(ausdruck);
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % Automat
        Z: z0 z1 z2
        E: z1
        S: z0
        A: a b
        z0 a z1
        z0 a z2
        z0 b z2
        z1 b z0
        z2 a z0
        z2 a z1
        z2 a z2
        z2 b z1
        """);
    ea.deterministisch().minimieren();
    EndlicherAutomat ea2 = RegulaererAusdruck.alsAusdruck(ausdruck).alsAutomat().deterministisch().minimieren();
    
    ea2.zustandsnamenKuerzen();
    System.out.println(ea2);
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      System.out.println(ea);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea2.akzeptieren(w) + " korrekt:" 
        + ea.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
