package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Terminal;
import alphabet.Wort;
import alphabet.Zeichen;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class Automat2Test {
  @Test
  public void testAutomat2() {
    Zeichen.reset();
    Terminal.reset();
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" 
        + util.Util.FS + "Automat2.atm");
    ea.deterministisch().minimieren();
    RegulaererAusdruck reg = RegulaererAusdruck
        .alsAusdruck("((b)*a(b)*a(b)*a(b)*)*(b)*", false);
    EndlicherAutomat ea2 = reg.alsAutomat().deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
