package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class Automat3malZeichenTest {
  @Test
  public void testAutomat3malZeichen() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "Automat3malZeichen.atm");
    Assertions.assertTrue(ea.istOhneEpsilon());
    ea.deterministisch().minimieren();
    RegulaererAusdruck reg = RegulaererAusdruck.alsAusdruck("((a+b)(a+b)(a+b))*", false);
    EndlicherAutomat ea2 = reg.alsAutomat().deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
