package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class AutomatAusRegulaeremAusdruck2Test {
  @Test
  public void testAutomatausRegulaeremAusdruck() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" 
        + util.Util.FS + "AutomatAusRegulaeremAusdruck2.atm");
    ea.deterministisch().minimieren();
    EndlicherAutomat ea2 = RegulaererAusdruck.alsAusdruck("((ab)*(ba)*)*").alsAutomat().deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    if (!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
    }
    Assertions.assertTrue(erg, util.Util.text(w) + " nicht korrekt bearbeitet");
  }
}
