package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class AutomatAusRegulaeremAusdruck3Test {
  @Test
  public void testAutomatausRegulaeremAusdruck() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % Automat_det
        Z: z0 z1
        E: z1
        S: z0
        A: a b c d
        z0 a z0
        z0 b z0
        z0 c z0
        z0 d z1
        """);
    ea.deterministisch().minimieren();
    EndlicherAutomat ea2 = RegulaererAusdruck.alsAusdruck("((((a+b))*+c))*d").alsAutomat().deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      System.out.println(ea);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
