package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;
import regulaererAusdruck.RegulaererAusdruck;

public class AutomatAusRegulaeremAusdruckTest {
  @Test
  public void testAutomatausRegulaeremAusdruck() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "AutomatAusRegulaeremAusdruck.atm");
    ea.deterministisch().minimieren();
    EndlicherAutomat ea2 = RegulaererAusdruck.alsAusdruck("((a+(ab)*))*").alsAutomat().deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
