package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;

public class AutomatDeterministischTest {
  @Test
  public void testAutomatUeberfuehrungCdet() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "AutomatCdet.atm");
    Assertions.assertTrue(ea.istDeterministisch(), "Automat ist nicht deterministisch.");
    ea.minimieren();
    EndlicherAutomat ea2 = new EndlicherAutomat();
    ea2.stringAlsAutomat("""
        A: a b
        Z: z0 z1 z2 z3 z4 z5
        E: z5
        S: z0
        z0 a z0
        z0 a z1
        z0 b z0
        z1 a z2
        z2 /eps z3
        z3 a z3
        z3 b z3
        z3 b z4
        z4 b z5
        z5 a z5
        z5 b z5
        """);
    ea2.deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
  
  @Test
  public void testAutomatUeberfuehrungDdet() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "AutomatDdet.atm");
    Assertions.assertTrue(ea.istDeterministisch(), "Automat ist nicht deterministisch.");
    ea.minimieren();
    EndlicherAutomat ea2 = new EndlicherAutomat();
    ea2.stringAlsAutomat("""
        A: a b
        Z: z0 z1 z2 z3 z4 z5 z6
        E: z3 z6
        S: z0
        z0 /eps z1
        z0 /eps z4
        z1 a z1
        z1 a z2
        z1 b z1
        z2 a z3
        z3 a z3
        z3 b z3
        z4 a z4
        z4 b z4
        z4 b z5
        z5 b z6
        z6 a z6
        z6 b z6
        """);
    ea2.deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
