package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;

public class AutomatErsteEingabeTest {

  @Test
  public void testAutomatUeberfuehrung() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "Uebung1.atm");
    ea.deterministisch().minimieren().zustandsnamenKuerzen(); 
    EndlicherAutomat ea2 = new EndlicherAutomat();
    ea2.stringAlsAutomat("""
        Z: z1 z2 z3
        E: z3
        S: z1
        A: a b 
        z1 a z2
        z1 b z2
        z2 a z3
        z2 b z3
        """);
    ea2.deterministisch().minimieren().zustandsnamenKuerzen(); 
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
    }
    Assertions.assertTrue(erg, util.Util.text(w) + " nicht korrekt bearbeitet");
  }
}
