package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import endlicherAutomat.EndlicherAutomat;
import grammatik.KontextfreieGrammatik;

public class AutomatGrammtikInAutomatTest {
  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "b", "aa", "ab", "ba", "bb", "aba", "abb"
          ,"aaaabb","abababaa", "aaaa", "bab", "aabb", "aabbb", "aaaabb" })
  public void testAutomatInGrammatik(String wort) {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen(
        "beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "AutomatGrammatikInAutomat.atm");
    ea.deterministisch().minimieren();
    KontextfreieGrammatik ea2 = new KontextfreieGrammatik();
    ea2.stringAlsGrammatik("""
        N: A B C
        T: a b
        S: A
        A -> A | B | C | /eps    
        B -> C | bb | /eps        
        C -> A | aaC
        """);
    Assertions.assertEquals(ea.akzeptieren(wort), ea2.ableitbar(wort)
        , util.Util.text(wort) + " wird nicht gleichbehandelt.");
  }
}
