package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import alphabet.Nichtterminal;
import alphabet.Terminal;
import alphabet.Zeichen;
import endlicherAutomat.EndlicherAutomat;
import grammatik.KontextfreieGrammatik;
import zustand.Zustand;

public class AutomatInGrammatikTest {
  @BeforeEach
  public void setUp() throws Exception {
    Terminal.reset();
    Nichtterminal.reset();
    Zeichen.reset();
    Zustand.reset();
  }
  
  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "b", "aa", "ab", "ba", "bb", "aaa", "aab"
          ,"aba", "abb", "baa", "bab", "bba", "bbb" 
          ,"aaaabbaaaba", "aabbbaaaabbbb" })
  public void testAutomatUmwandeln1(String wort) {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % Worte die auf A enden
        Z: z1 z2
        E: z2
        S: z1
        A: a b 
        z1 a z2
        z1 b z1
        z2 a z2
        z2 b z1
        """);
    KontextfreieGrammatik kfg = ea.alsGrammatik();
    Assertions.assertEquals(ea.akzeptieren(wort), kfg.ableitbar(wort), 
        "\"" + util.Util.text(wort) + "\"" + " sollte " 
        + (ea.akzeptieren(wort)? "": "nicht ") + "ableitbar sein in\n");
  }
  
  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "b", "aa", "ab", "ba", "bb", "aaa", "aab"
          ,"aba", "abb", "baa", "bab", "bba", "bbb" 
          ,"aaaabbaaaba", "aabbbaaaabbbb" })
  public void testAutomatUmwandeln2(String wort) {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % Worte die nicht auf a enden
        Z: z1 z2
        E: z1
        S: z1
        A: a b 
        z1 a z2
        z1 b z1
        z2 a z2
        z2 b z1
        """);
    KontextfreieGrammatik kfg = ea.alsGrammatik();
    Assertions.assertEquals(ea.akzeptieren(wort), kfg.ableitbar(wort), 
        "\"" + wort + "\"" + " sollte " 
        + (ea.akzeptieren(wort)? "": "nicht ") + "ableitbar sein in\n");
  }
  
  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "b", "aa", "ab", "ba", "bb", "aaa", "aab"
          ,"aba", "abb", "baa", "bab", "bba", "bbb" 
          ,"aaaabbaaaba", "aabbbaaaabbbb" })
  public void testAutomatUmwandeln3(String wort) {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % akzeptiert alle Worte (mit unsinnigen Zustaenden)
        Z: z1 z2 z3 z0
        E: z1
        S: z0
        A: a b
        z0 /eps z1
        z0 a z0
        z0 b z0 
        z1 a z2
        z1 a z1
        z1 b z1
        z2 a z3
        z3 a z3
        z3 b z3
        """);
    KontextfreieGrammatik kfg = ea.alsGrammatik();
    Assertions.assertEquals(ea.akzeptieren(wort), kfg.ableitbar(wort), 
        "\"" + wort + "\"" + " sollte " 
        + (ea.akzeptieren(wort)? "": "nicht ") + "ableitbar sein in " + kfg);
  }
  
  public void testAutomatleeresWort() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % akzeptiert alle Worte (mit unsinnigen Zustaenden)
        Z: z1 z2 z3 z4 z0
        E: z3
        S: z0
        A: a b
        z0 /eps z1
        z1 /eps z2
        z2 /eps z1
        z2 /eps z3
        z3 /eps z3
        z2 a    z4
        z2 b    z4
        z4 /eps z4
        """);
    Assertions.assertTrue(ea.akzeptieren(""));
    Assertions.assertFalse(ea.akzeptieren("a"));
    Assertions.assertFalse(ea.akzeptieren("b"));
  }
  
  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "b", "aa", "ab", "ba", "bb", "aaa", "aab"
          ,"aba", "abb", "baa", "bab", "bba", "bbb" 
          ,"aaaabbaaaba", "aabbbaaaabbbb" })
  public void testAutomatUmwandeln4(String wort) {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % Worte die aa enthalten
        Z: z1 z2 z3 z0 zx
        E: z3
        S: z0
        A: a b
        z0 /eps z1
        z0 a z0
        z0 b z0 
        z1 a zx
        z1 a z1
        z1 b z1
        zx /eps z2
        z2 a z3
        z3 a z3
        z3 b z3
        """);
    KontextfreieGrammatik kfg = ea.alsGrammatik();
    Assertions.assertEquals(ea.akzeptieren(wort), kfg.ableitbar(wort), 
        "\"" + wort + "\"" + " sollte " 
        + (ea.akzeptieren(wort)? "": "nicht ") + "ableitbar sein in\n");
  }
}
