package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import endlicherAutomat.EndlicherAutomat;
import grammatik.KontextfreieGrammatik;

public class AutomatInGrammatikWandelnTest {

  @ParameterizedTest
  @ValueSource(
      strings = { "", "a", "b", "aa", "ab", "ba", "bb", "aba", "abb"
          ,"abaa","abababaa", "abba", "bab", "babb", "baba", "babababb" })
  public void testAutomatInGrammatik(String wort) {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.stringAlsAutomat("""
        % Automat zur Minimerung aus der Vorlesung
        A: a b
        Z: start Z1 Z2 Z3 Z4 Z5 Z6 Z7
        E: Z3
        S: start
        start /eps Z1
        start b Z4
        Z1 /eps Z2
        Z1 b Z5
        Z2 /eps Z3
        Z2 b Z6
        Z3 /eps start
        Z3 a Z7
        Z4 a start
        Z5 b Z1
        Z6 a Z2
        Z7 a Z3
        """);
    ea.deterministisch().minimieren();
    KontextfreieGrammatik ea2 = new KontextfreieGrammatik();
    ea2.dateiEinlesen(
        "beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "AutomatInGrammatik.kfg");
    Assertions.assertEquals(ea.akzeptieren(wort), ea2.ableitbar(wort)
        , util.Util.text(wort) + " wird nicht gleichbehandelt.");
  }
}
