package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;

public class AutomatMinimiertTest {
  @Test
  public void testAutomatUeberfuehrungCdet() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" 
        + util.Util.FS + "AutomatMinimiert.atm");
    Assertions.assertTrue(ea.istDeterministisch(), "Automat ist nicht deterministisch.");
    EndlicherAutomat ea2 = new EndlicherAutomat();
    ea2.stringAlsAutomat("""
        % Automat_vorMinimierungProbe
        Z: z0 z1 z2 z3 z4 z5 z6 z7 z8
        E: z0 z3 z6
        S: z0
        A: a b
        z0 a z1
        z0 b z4
        z1 a z2
        z1 b z5
        z2 a z3
        z2 b z6
        z3 a z8
        z3 b z7
        z4 a z2
        z4 b z5
        z5 a z3
        z5 b z6 
        z6 a z8
        z6 b z7
        z7 a z2
        z7 b z5
        z8 a z2
        z8 b z5
        """);
    ea2.minimieren();
    ea2.zeigeMinimierungsmatrix();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
