package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;

public class AutomatProbeklausur2Test {
  @Test
  public void testAutomatUeberfuehrung() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" + util.Util.FS + "Probeklausur2.atm");
    Assertions.assertTrue(ea.istDeterministisch());
    ea.minimieren();
    EndlicherAutomat ea2 = new EndlicherAutomat();
    ea2.stringAlsAutomat("""
        A: a b
        Z: z0 z1 z2 z3
        E: z3
        S: z0
        z0 a z3
        z0 b z1
        z1 a z0
        z1 a z3
        z1 b z2
        z2 a z1
        z2 a z3
        z2 b z3
        """);
    ea2.deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
