package test.endlicherAutomat;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import alphabet.Wort;
import endlicherAutomat.EndlicherAutomat;

public class AutomatProbeklausur4Test {
  @Test
  public void testAutomatUeberfuehrung() {
    EndlicherAutomat ea = new EndlicherAutomat();
    ea.dateiEinlesen("beispiele" + util.Util.FS + "endlicheautomaten" 
       + util.Util.FS + "Probeklausur4.atm");
    Assertions.assertTrue(ea.istDeterministisch());
    ea.minimieren();
    EndlicherAutomat ea2 = new EndlicherAutomat();
    ea2.stringAlsAutomat("""
        Z: z0003 z0004 z0005 z0006 z0007 z0008 z0009 
        E: z0004 z0008 z0009 
        A: a b 
        S: z0003
        z0007 a z0009 
        z0008 b z0007 
        z0007 b z0006 
        z0006 a z0006 
        z0009 a z0003 
        z0009 b z0008 
        z0008 a z0009 
        z0004 b z0007 
        z0003 a z0004 
        z0003 b z0005 
        z0006 b z0006 
        z0005 a z0003 
        z0004 a z0006 
        z0005 b z0008 
        """);
    ea2.deterministisch().minimieren();
    boolean erg = ea.istMinimalIsomorph(ea2);
    Wort w = null;
    String text = "";
    if(!erg) {
      w = ea.nichtGemeinsamesWort(ea2);
      text = util.Util.text(w) + " nicht korrekt bearbeitet,"
        +" Ihr Automat:" + ea.akzeptieren(w) + " korrekt:" 
        + ea2.akzeptieren(w);
    }
    Assertions.assertTrue(erg, text);
  }
}
